/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model;

import jakarta.xml.bind.JAXBException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.sparkproject.dmg.pmml.PMML;
import org.sparkproject.jpmml.model.JAXBSerializer;
import org.sparkproject.jpmml.model.SAXUtil;
import org.sparkproject.jpmml.model.ServiceLoaderUtil;
import org.sparkproject.jpmml.model.filters.ImportFilter;
import org.xml.sax.SAXException;

public class PMMLUtil {
    private PMMLUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PMML load(URL url) throws IOException {
        URLClassLoader clazzLoader = URLClassLoader.newInstance(new URL[]{url});
        try {
            PMML pMML = PMMLUtil.load(clazzLoader);
            return pMML;
        }
        finally {
            if (clazzLoader instanceof Closeable) {
                URLClassLoader closeable = clazzLoader;
                closeable.close();
            }
        }
    }

    public static PMML load(ClassLoader clazzLoader) {
        return ServiceLoaderUtil.load(PMML.class, clazzLoader);
    }

    public static PMML unmarshal(InputStream is) throws ParserConfigurationException, SAXException, JAXBException {
        JAXBSerializer serializer = new JAXBSerializer();
        SAXSource source = SAXUtil.createFilteredSource(is, new ImportFilter());
        return (PMML)serializer.unmarshal(source);
    }

    public static void marshal(PMML pmml, OutputStream os) throws JAXBException {
        JAXBSerializer serializer = new JAXBSerializer();
        StreamResult result = new StreamResult(os);
        serializer.marshal(pmml, result);
    }
}

