/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.ArrayImplicits$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;

public final class ReadWriteUtils$ {
    public static final ReadWriteUtils$ MODULE$ = new ReadWriteUtils$();
    private static final ThreadLocal<Object> localSavingModeState = new ThreadLocal<Object>(){

        public boolean initialValue() {
            return false;
        }
    };

    public ThreadLocal<Object> localSavingModeState() {
        return localSavingModeState;
    }

    public void serializeIntArray(int[] array, DataOutputStream dos) {
        dos.writeInt(array.length);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), array.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> dos.writeInt(array[i]));
    }

    public int[] deserializeIntArray(DataInputStream dis) {
        int len = dis.readInt();
        int[] data = new int[len];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            data$1[i] = dis.readInt();
        });
        return data;
    }

    public void serializeLongArray(long[] array, DataOutputStream dos) {
        dos.writeInt(array.length);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), array.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> dos.writeLong(array[i]));
    }

    public long[] deserializeLongArray(DataInputStream dis) {
        int len = dis.readInt();
        long[] data = new long[len];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            data$2[i] = dis.readLong();
        });
        return data;
    }

    public void serializeFloatArray(float[] array, DataOutputStream dos) {
        dos.writeInt(array.length);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), array.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> dos.writeFloat(array[i]));
    }

    public float[] deserializeFloatArray(DataInputStream dis) {
        int len = dis.readInt();
        float[] data = new float[len];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            data$3[i] = dis.readFloat();
        });
        return data;
    }

    public void serializeDoubleArray(double[] array, DataOutputStream dos) {
        dos.writeInt(array.length);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), array.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> dos.writeDouble(array[i]));
    }

    public double[] deserializeDoubleArray(DataInputStream dis) {
        int len = dis.readInt();
        double[] data = new double[len];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            data$4[i] = dis.readDouble();
        });
        return data;
    }

    public void serializeStringArray(String[] array, DataOutputStream dos2) {
        this.serializeGenericArray(array, dos2, (Function2 & Serializable)(s, dos) -> {
            dos.writeUTF(s);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.apply(String.class));
    }

    public String[] deserializeStringArray(DataInputStream dis2) {
        return (String[])this.deserializeGenericArray(dis2, (Function1 & Serializable)dis -> dis.readUTF(), ClassTag$.MODULE$.apply(String.class));
    }

    public <K, V> void serializeMap(Map<K, V> map, DataOutputStream dos, Function2<K, DataOutputStream, BoxedUnit> keySerializer, Function2<V, DataOutputStream, BoxedUnit> valueSerializer) {
        dos.writeInt(map.size());
        map.foreach((Function1 & Serializable)x0$1 -> {
            ReadWriteUtils$.$anonfun$serializeMap$1(keySerializer, dos, valueSerializer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public <K, V> Map<K, V> deserializeMap(DataInputStream dis, Function1<DataInputStream, K> keyDeserializer, Function1<DataInputStream, V> valueDeserializer) {
        int len = dis.readInt();
        Tuple2[] kvList = new Tuple2[len];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Object key = keyDeserializer.apply((Object)dis);
            Object value = valueDeserializer.apply((Object)dis);
            kvList$1[i] = new Tuple2(key, value);
        });
        return Predef$.MODULE$.wrapRefArray((Object[])kvList).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void serializeVector(Vector vector, DataOutputStream dos) {
        if (vector instanceof DenseVector) {
            dos.writeBoolean(false);
            this.serializeDoubleArray(vector.toArray(), dos);
            return;
        }
        SparseVector sparseVec = (SparseVector)vector;
        dos.writeBoolean(true);
        dos.writeInt(sparseVec.size());
        this.serializeIntArray(sparseVec.indices(), dos);
        this.serializeDoubleArray(sparseVec.values(), dos);
    }

    public Vector deserializeVector(DataInputStream dis) {
        boolean isSparse = dis.readBoolean();
        if (isSparse) {
            int len = dis.readInt();
            int[] indices = this.deserializeIntArray(dis);
            double[] values = this.deserializeDoubleArray(dis);
            return new SparseVector(len, indices, values);
        }
        double[] values = this.deserializeDoubleArray(dis);
        return new DenseVector(values);
    }

    public void serializeMatrix(Matrix matrix, DataOutputStream dos) {
        if (matrix instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)matrix;
            dos.writeBoolean(false);
            ReadWriteUtils$.serializeCommon$1(dos, matrix);
            this.serializeDoubleArray(denseMatrix.values(), dos);
            return;
        }
        SparseMatrix sparseMatrix = (SparseMatrix)matrix;
        dos.writeBoolean(true);
        ReadWriteUtils$.serializeCommon$1(dos, matrix);
        this.serializeIntArray(sparseMatrix.colPtrs(), dos);
        this.serializeIntArray(sparseMatrix.rowIndices(), dos);
        this.serializeDoubleArray(sparseMatrix.values(), dos);
    }

    public Matrix deserializeMatrix(DataInputStream dis) {
        boolean isSparse = dis.readBoolean();
        if (isSparse) {
            Tuple3 tuple3 = ReadWriteUtils$.deserializeCommon$1(dis);
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int numRows = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int numCols = BoxesRunTime.unboxToInt((Object)tuple3._2());
            boolean transposed = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)numRows), (Object)BoxesRunTime.boxToInteger((int)numCols), (Object)BoxesRunTime.boxToBoolean((boolean)transposed));
            int numRows2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int numCols2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            boolean transposed2 = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
            int[] colPtrs = this.deserializeIntArray(dis);
            int[] rowIndices = this.deserializeIntArray(dis);
            double[] values = this.deserializeDoubleArray(dis);
            return new SparseMatrix(numRows2, numCols2, colPtrs, rowIndices, values, transposed2);
        }
        Tuple3 tuple3 = ReadWriteUtils$.deserializeCommon$1(dis);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int numRows = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int numCols = BoxesRunTime.unboxToInt((Object)tuple3._2());
        boolean transposed = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)numRows), (Object)BoxesRunTime.boxToInteger((int)numCols), (Object)BoxesRunTime.boxToBoolean((boolean)transposed));
        int numRows3 = BoxesRunTime.unboxToInt((Object)tuple33._1());
        int numCols3 = BoxesRunTime.unboxToInt((Object)tuple33._2());
        boolean transposed3 = BoxesRunTime.unboxToBoolean((Object)tuple33._3());
        double[] values = this.deserializeDoubleArray(dis);
        return new DenseMatrix(numRows3, numCols3, values, transposed3);
    }

    public <T> void serializeGenericArray(Object array, DataOutputStream dos, Function2<T, DataOutputStream, BoxedUnit> serializer, ClassTag<T> evidence$1) {
        dos.writeInt(ScalaRunTime$.MODULE$.array_length(array));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(array), (Function1 & Serializable)item -> {
            serializer.apply(item, (Object)dos);
            return BoxedUnit.UNIT;
        });
    }

    public <T> Object deserializeGenericArray(DataInputStream dis, Function1<DataInputStream, T> deserializer, ClassTag<T> evidence$2) {
        int len = dis.readInt();
        Object data = evidence$2.newArray(len);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ScalaRunTime$.MODULE$.array_update(data, i, deserializer.apply((Object)dis)));
        return data;
    }

    public void saveText(String path, String data, SparkSession spark) {
        if (BoxesRunTime.unboxToBoolean((Object)this.localSavingModeState().get())) {
            Path filePath = Paths.get(path, new String[0]);
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            Files.writeString(filePath, (CharSequence)data, new OpenOption[0]);
            return;
        }
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_ReadWriteUtils$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_util_ReadWriteUtils$$typecreator1$1() {
            }
        }
        spark.createDataFrame((Seq)new .colon.colon((Object)new Tuple1((Object)data), (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_ReadWriteUtils$$typecreator1$1())).write().text(path);
    }

    public String loadText(String path, SparkSession spark) {
        if (BoxesRunTime.unboxToBoolean((Object)this.localSavingModeState().get())) {
            return Files.readString(Paths.get(path, new String[0]));
        }
        return ((Row)spark.read().text(path).first()).getString(0);
    }

    public <T extends Product> void saveObjectToLocal(String path, T data, Function2<T, DataOutputStream, BoxedUnit> serializer, ClassTag<T> evidence$3, TypeTags.TypeTag<T> evidence$4) {
        Path filePath = Paths.get(path, new String[0]);
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        Using$.MODULE$.resource((Object)new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filePath.toFile()))), (Function1 & Serializable)dos -> {
            serializer.apply((Object)data, (Object)dos);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public <T extends Product> void saveObject(String path, T data, SparkSession spark, Function2<T, DataOutputStream, BoxedUnit> localSerializer, ClassTag<T> evidence$5, TypeTags.TypeTag<T> evidence$6) {
        if (BoxesRunTime.unboxToBoolean((Object)this.localSavingModeState().get())) {
            this.saveObjectToLocal(path, data, localSerializer, evidence$5, evidence$6);
            return;
        }
        spark.createDataFrame((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Product[]{data})), evidence$6).write().parquet(path);
    }

    public <T extends Product> T loadObjectFromLocal(String path, Function1<DataInputStream, T> deserializer, ClassTag<T> evidence$7, TypeTags.TypeTag<T> evidence$8) {
        return (T)((Product)Using$.MODULE$.resource((Object)new DataInputStream(new BufferedInputStream(new FileInputStream(path))), (Function1 & Serializable)dis -> (Product)deserializer.apply(dis), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
    }

    public <T extends Product> T loadObject(String path, SparkSession spark, Function1<DataInputStream, T> localDeserializer, ClassTag<T> evidence$9, TypeTags.TypeTag<T> evidence$10) {
        if (BoxesRunTime.unboxToBoolean((Object)this.localSavingModeState().get())) {
            return this.loadObjectFromLocal(path, localDeserializer, evidence$9, evidence$10);
        }
        return (T)((Product)spark.read().parquet(path).as(spark.implicits().newProductEncoder(evidence$10)).head());
    }

    public <T extends Product> void saveArray(String path, Object data, SparkSession spark, Function2<T, DataOutputStream, BoxedUnit> localSerializer, int numDataParts, ClassTag<T> evidence$11, TypeTags.TypeTag<T> evidence$12) {
        if (BoxesRunTime.unboxToBoolean((Object)this.localSavingModeState().get())) {
            Path filePath = Paths.get(path, new String[0]);
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            Using$.MODULE$.resource((Object)new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filePath.toFile()))), (Function1 & Serializable)dos -> {
                ReadWriteUtils$.MODULE$.serializeGenericArray(data, dos, localSerializer, evidence$11);
                return BoxedUnit.UNIT;
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            return;
        }
        Dataset df = spark.createDataFrame((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(data).toImmutableArraySeq(), evidence$12);
        if (numDataParts == -1) {
            df.write().parquet(path);
            return;
        }
        df.repartition(numDataParts).write().parquet(path);
    }

    public <T extends Product> int saveArray$default$5() {
        return -1;
    }

    public <T extends Product> Object loadArray(String path, SparkSession spark, Function1<DataInputStream, T> localDeserializer, ClassTag<T> evidence$13, TypeTags.TypeTag<T> evidence$14) {
        if (BoxesRunTime.unboxToBoolean((Object)this.localSavingModeState().get())) {
            return Using$.MODULE$.resource((Object)new DataInputStream(new BufferedInputStream(new FileInputStream(path))), (Function1 & Serializable)dis -> MODULE$.deserializeGenericArray((DataInputStream)dis, localDeserializer, evidence$13), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }
        return spark.read().parquet(path).as(spark.implicits().newProductEncoder(evidence$14)).collect();
    }

    public static final /* synthetic */ void $anonfun$serializeMap$1(Function2 keySerializer$1, DataOutputStream dos$5, Function2 valueSerializer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object k = tuple2._1();
            Object v = tuple2._2();
            keySerializer$1.apply(k, (Object)dos$5);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)valueSerializer$1.apply(v, (Object)dos$5);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final void serializeCommon$1(DataOutputStream dos$6, Matrix matrix$1) {
        dos$6.writeInt(matrix$1.numRows());
        dos$6.writeInt(matrix$1.numCols());
        dos$6.writeBoolean(matrix$1.isTransposed());
    }

    private static final Tuple3 deserializeCommon$1(DataInputStream dis$6) {
        int numRows = dis$6.readInt();
        int numCols = dis$6.readInt();
        boolean transposed = dis$6.readBoolean();
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)numRows), (Object)BoxesRunTime.boxToInteger((int)numCols), (Object)BoxesRunTime.boxToBoolean((boolean)transposed));
    }

    private ReadWriteUtils$() {
    }
}

