/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.text.NumberFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.spark.KryoSerializer;
import org.apache.hadoop.hive.ql.exec.spark.SmallTableCache;
import org.apache.hadoop.hive.ql.exec.spark.SparkReporter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.TaskContext;
import org.apache.spark.api.java.function.PairFlatMapFunction;

public abstract class HivePairFlatMapFunction<T, K, V>
implements PairFlatMapFunction<T, K, V> {
    private final NumberFormat taskIdFormat = NumberFormat.getInstance();
    private final NumberFormat stageIdFormat = NumberFormat.getInstance();
    protected transient JobConf jobConf;
    protected SparkReporter sparkReporter;
    private byte[] buffer;

    public HivePairFlatMapFunction(byte[] buffer, SparkReporter sparkReporter) {
        this.taskIdFormat.setGroupingUsed(false);
        this.taskIdFormat.setMinimumIntegerDigits(6);
        this.stageIdFormat.setGroupingUsed(false);
        this.stageIdFormat.setMinimumIntegerDigits(4);
        this.buffer = buffer;
        this.sparkReporter = sparkReporter;
    }

    protected void initJobConf() {
        if (this.jobConf == null) {
            this.jobConf = KryoSerializer.deserializeJobConf(this.buffer);
            SmallTableCache.initialize((Configuration)this.jobConf);
            this.setupMRLegacyConfigs();
        }
    }

    protected abstract boolean isMap();

    private void setupMRLegacyConfigs() {
        StringBuilder taskAttemptIdBuilder = new StringBuilder("attempt_");
        taskAttemptIdBuilder.append(System.currentTimeMillis()).append("_").append(this.stageIdFormat.format(TaskContext.get().stageId())).append("_");
        if (this.isMap()) {
            taskAttemptIdBuilder.append("m_");
        } else {
            taskAttemptIdBuilder.append("r_");
        }
        taskAttemptIdBuilder.append(this.taskIdFormat.format(TaskContext.get().partitionId())).append("_").append(TaskContext.get().attemptNumber());
        String taskAttemptIdStr = taskAttemptIdBuilder.toString();
        this.jobConf.set("mapred.task.id", taskAttemptIdStr);
        this.jobConf.set("mapreduce.task.attempt.id", taskAttemptIdStr);
        this.jobConf.setInt("mapred.task.partition", TaskContext.get().partitionId());
    }
}

