/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.aggregate.Collect;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectSet$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.UnsafeRowUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Collects and returns a set of unique elements.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (1) AS tab(col);\n       [1,2]\n  ", note="\n    The function is non-deterministic because the order of collected results depends\n    on the order of the rows which may be non-deterministic after a shuffle.\n  ", group="agg_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0005\t\rc\u0001\u0002\u0015*\u0001bB\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\tY\u0002\u0011\t\u0012)A\u0005/\"AQ\u000e\u0001BK\u0002\u0013\u0005a\u000e\u0003\u0005s\u0001\tE\t\u0015!\u0003p\u0011!\u0019\bA!f\u0001\n\u0003q\u0007\u0002\u0003;\u0001\u0005#\u0005\u000b\u0011B8\t\u000bU\u0004A\u0011\u0001<\t\u000bU\u0004A\u0011A>\t\u0011u\u0004\u0001R1A\u0005ByDq!a\u0003\u0001\t\u0003\ni\u0001C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA\u001d\u0001\u0011\u0005\u00131\b\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0011\u001d\t)\u0006\u0001C!\u0003/Bq!!\u0017\u0001\t#\nY\u0006C\u0005\u0002b\u0001\t\t\u0011\"\u0001\u0002d!I\u00111\u000e\u0001\u0012\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003\u0007\u0003\u0011\u0013!C\u0001\u0003\u000bC\u0011\"!#\u0001#\u0003%\t!!\"\t\u0013\u0005-\u0005!!A\u0005B\u00055\u0005\u0002CAO\u0001\u0005\u0005I\u0011\u00018\t\u0013\u0005}\u0005!!A\u0005\u0002\u0005\u0005\u0006\"CAT\u0001\u0005\u0005I\u0011IAU\u0011%\t\u0019\fAA\u0001\n\u0003\t)\fC\u0005\u0002@\u0002\t\t\u0011\"\u0011\u0002B\"I\u0011Q\u0019\u0001\u0002\u0002\u0013\u0005\u0013qY\u0004\n\u0003cL\u0013\u0011!E\u0001\u0003g4\u0001\u0002K\u0015\u0002\u0002#\u0005\u0011Q\u001f\u0005\u0007kz!\tA!\u0004\t\u0013\t=a$!A\u0005F\tE\u0001\"\u0003B\n=\u0005\u0005I\u0011\u0011B\u000b\u0011%\u0011iBHI\u0001\n\u0003\t)\tC\u0005\u0003 y\t\n\u0011\"\u0001\u0002\u0006\"I!\u0011\u0005\u0010\u0002\u0002\u0013\u0005%1\u0005\u0005\n\u0005kq\u0012\u0013!C\u0001\u0003\u000bC\u0011Ba\u000e\u001f#\u0003%\t!!\"\t\u0013\teb$!A\u0005\n\tm\"AC\"pY2,7\r^*fi*\u0011!fK\u0001\nC\u001e<'/Z4bi\u0016T!\u0001L\u0017\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003]=\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003aE\n1a]9m\u0015\t\u00114'A\u0003ta\u0006\u00148N\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<7\u0001A\n\u0007\u0001eZ\u0015k\u00170\u0011\u0007iZT(D\u0001*\u0013\ta\u0014FA\u0004D_2dWm\u0019;\u0011\u0007y*u)D\u0001@\u0015\t\u0001\u0015)A\u0004nkR\f'\r\\3\u000b\u0005\t\u001b\u0015AC2pY2,7\r^5p]*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u007f\t9\u0001*Y:i'\u0016$\bC\u0001%J\u001b\u0005\u0019\u0015B\u0001&D\u0005\r\te.\u001f\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d>\na!\u001a:s_J\u001c\u0018B\u0001)N\u0005=\tV/\u001a:z\u000bJ\u0014xN]:CCN,\u0007c\u0001*V/6\t1K\u0003\u0002U[\u0005)AO]3fg&\u0011ak\u0015\u0002\n+:\f'/\u001f'jW\u0016\u0004\"\u0001W-\u000e\u0003-J!AW\u0016\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002I9&\u0011Ql\u0011\u0002\b!J|G-^2u!\tyvM\u0004\u0002aK:\u0011\u0011\rZ\u0007\u0002E*\u00111mN\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011K!AZ\"\u0002\u000fA\f7m[1hK&\u0011\u0001.\u001b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003M\u000e\u000bQa\u00195jY\u0012,\u0012aV\u0001\u0007G\"LG\u000e\u001a\u0011\u0002-5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR,\u0012a\u001c\t\u0003\u0011BL!!]\"\u0003\u0007%sG/A\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3uA\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fQ#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u0004=S:LGO\u0010\u000b\u0005obL(\u0010\u0005\u0002;\u0001!)!n\u0002a\u0001/\"9Qn\u0002I\u0001\u0002\u0004y\u0007bB:\b!\u0003\u0005\ra\u001c\u000b\u0003orDQA\u001b\u0005A\u0002]\u000b\u0011CY;gM\u0016\u0014X\t\\3nK:$H+\u001f9f+\u0005y\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015q&A\u0003usB,7/\u0003\u0003\u0002\n\u0005\r!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002-\r|gN^3siR{')\u001e4gKJ,E.Z7f]R$2aRA\b\u0011\u0019\t\tB\u0003a\u0001\u000f\u0006)a/\u00197vK\u0006!QM^1m)\r9\u0015q\u0003\u0005\u0007\u00033Y\u0001\u0019A\u001f\u0002\r\t,hMZ3s\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\ty\u0002\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)#L\u0001\tC:\fG._:jg&!\u0011\u0011FA\u0012\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018!H<ji\"tUm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\t\u0005=\u0012Q\u0007\t\u0004u\u0005E\u0012bAA\u001aS\t\u0019\u0012*\u001c9fe\u0006$\u0018N^3BO\u001e\u0014XmZ1uK\"1\u0011qG\u0007A\u0002=\f\u0011D\\3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$B!a\f\u0002>!1\u0011q\b\bA\u0002=\fqC\\3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002FA!\u0011qIA(\u001d\u0011\tI%a\u0013\u0011\u0005\u0005\u001c\u0015bAA'\u0007\u00061\u0001K]3eK\u001aLA!!\u0015\u0002T\t11\u000b\u001e:j]\u001eT1!!\u0014D\u0003]\u0019'/Z1uK\u0006;wM]3hCRLwN\u001c\"vM\u001a,'\u000fF\u0001>\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019q/!\u0018\t\r\u0005}\u0013\u00031\u0001X\u0003!qWm^\"iS2$\u0017\u0001B2paf$ra^A3\u0003O\nI\u0007C\u0004k%A\u0005\t\u0019A,\t\u000f5\u0014\u0002\u0013!a\u0001_\"91O\u0005I\u0001\u0002\u0004y\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003_R3aVA9W\t\t\u0019\b\u0005\u0003\u0002v\u0005}TBAA<\u0015\u0011\tI(a\u001f\u0002\u0013Ut7\r[3dW\u0016$'bAA?\u0007\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0015q\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000fS3a\\A9\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAH!\u0011\t\t*a'\u000e\u0005\u0005M%\u0002BAK\u0003/\u000bA\u0001\\1oO*\u0011\u0011\u0011T\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002R\u0005M\u0015\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004\u000f\u0006\r\u0006\u0002CAS1\u0005\u0005\t\u0019A8\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\u000bE\u0003\u0002.\u0006=v)D\u0001B\u0013\r\t\t,\u0011\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00028\u0006u\u0006c\u0001%\u0002:&\u0019\u00111X\"\u0003\u000f\t{w\u000e\\3b]\"A\u0011Q\u0015\u000e\u0002\u0002\u0003\u0007q)\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAH\u0003\u0007D\u0001\"!*\u001c\u0003\u0003\u0005\ra\\\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005]\u0016\u0011\u001a\u0005\t\u0003Kc\u0012\u0011!a\u0001\u000f\":\u0002!!4\u0002T\u0006U\u0017\u0011\\An\u0003?\f\t/!:\u0002h\u0006-\u0018Q\u001e\t\u00041\u0006=\u0017bAAiW\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAl\u0003uzf)\u0016(D?\"*\u0007\u0010\u001d:*A5\u00023i\u001c7mK\u000e$8\u000fI1oI\u0002\u0012X\r^;s]N\u0004\u0013\rI:fi\u0002zg\rI;oSF,X\rI3mK6,g\u000e^:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAo\u0003\u0001T\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mS\u00012%kT'!-\u0006cU+R*!QEJC\u0006\t\u00153S1\u0002\u0003&M\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1\u0012TL\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u0005\r\u0018!a\u0013\u000bA\u0001\u0002\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u0004\u0013n\u001d\u0011o_:lC-\u001a;fe6Lg.[:uS\u000e\u0004#-Z2bkN,\u0007\u0005\u001e5fA=\u0014H-\u001a:!_\u001a\u00043m\u001c7mK\u000e$X\r\u001a\u0011sKN,H\u000e^:!I\u0016\u0004XM\u001c3t\u0015\u0001\u0002\u0003\u0005I8oAQDW\rI8sI\u0016\u0014\be\u001c4!i\",\u0007E]8xg\u0002:\b.[2iA5\f\u0017\u0010\t2fA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7\rI1gi\u0016\u0014\b%\u0019\u0011tQV4g\r\\3/\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAu\u0003%\twmZ0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002p\u0006)!G\f\u0019/a\u0005Q1i\u001c7mK\u000e$8+\u001a;\u0011\u0005ir2#\u0002\u0010\u0002x\n\r\u0001\u0003CA}\u0003\u007f<vn\\<\u000e\u0005\u0005m(bAA\u007f\u0007\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u0001\u0003w\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0003/\u000b!![8\n\u0007!\u00149\u0001\u0006\u0002\u0002t\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0010\u0006)\u0011\r\u001d9msR9qOa\u0006\u0003\u001a\tm\u0001\"\u00026\"\u0001\u00049\u0006bB7\"!\u0003\u0005\ra\u001c\u0005\bg\u0006\u0002\n\u00111\u0001p\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0005B\u0019!\u0015A%q\u0005B\u0016\u0013\r\u0011Ic\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r!\u0013icV8p\u0013\r\u0011yc\u0011\u0002\u0007)V\u0004H.Z\u001a\t\u0011\tMB%!AA\u0002]\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u0010\u0011\t\u0005E%qH\u0005\u0005\u0005\u0003\n\u0019J\u0001\u0004PE*,7\r\u001e")
public class CollectSet
extends Collect<HashSet<Object>>
implements QueryErrorsBase,
UnaryLike<Expression>,
Serializable {
    private DataType bufferElementType;
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$3() {
        return CollectSet$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CollectSet$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(CollectSet x$0) {
        return CollectSet$.MODULE$.unapply(x$0);
    }

    public static int apply$default$3() {
        return CollectSet$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return CollectSet$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, CollectSet> tupled() {
        return CollectSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, CollectSet>>> curried() {
        return CollectSet$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    private Seq<Expression> children$lzycompute() {
        CollectSet collectSet = this;
        synchronized (collectSet) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType bufferElementType$lzycompute() {
        CollectSet collectSet = this;
        synchronized (collectSet) {
            if (!this.bitmap$0) {
                DataType dataType = this.child().dataType();
                this.bufferElementType = BinaryType$.MODULE$.equals(dataType) ? ArrayType$.MODULE$.apply((DataType)ByteType$.MODULE$) : dataType;
                this.bitmap$0 = true;
            }
        }
        return this.bufferElementType;
    }

    @Override
    public DataType bufferElementType() {
        if (!this.bitmap$0) {
            return this.bufferElementType$lzycompute();
        }
        return this.bufferElementType;
    }

    @Override
    public Object convertToBufferElement(Object value) {
        DataType dataType = this.child().dataType();
        if (BinaryType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((byte[])value);
        }
        return InternalRow$.MODULE$.copyValue(value);
    }

    @Override
    public Object eval(HashSet<Object> buffer) {
        DataType dataType = this.child().dataType();
        Object[] array = BinaryType$.MODULE$.equals(dataType) ? (Object[])buffer.iterator().map((Function1 & Serializable)x$2 -> ((ArrayData)x$2).toByteArray()).toArray(ClassTag$.MODULE$.Any()) : (Object[])buffer.toArray(ClassTag$.MODULE$.Any());
        return new GenericArrayData(array);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (!this.child().dataType().existsRecursively((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CollectSet.$anonfun$checkInputDataTypes$1(x$3))) && UnsafeRowUtils$.MODULE$.isBinaryStable(this.child().dataType())) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.DataTypeMismatch("UNSUPPORTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)(this.toSQLType((AbstractDataType)MapType$.MODULE$) + " or \"COLLATED STRING\""))}))));
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public String prettyName() {
        return "collect_set";
    }

    @Override
    public HashSet<Object> createAggregationBuffer() {
        return HashSet$.MODULE$.empty();
    }

    @Override
    public CollectSet withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public CollectSet copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CollectSet(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CollectSet";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CollectSet;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "mutableAggBufferOffset";
            }
            case 2: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CollectSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        CollectSet collectSet = (CollectSet)x$1;
        if (this.mutableAggBufferOffset() != collectSet.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != collectSet.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = collectSet.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!collectSet.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$1(DataType x$3) {
        return x$3 instanceof MapType;
    }

    public CollectSet(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        UnaryLike.$init$(this);
    }

    public CollectSet(Expression child) {
        this(child, 0, 0);
    }
}

