/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BinaryClassificationMetricsExample$ {
    public static final BinaryClassificationMetricsExample$ MODULE$ = new BinaryClassificationMetricsExample$();

    public void main(String[] args) {
        Object object;
        SparkConf conf = new SparkConf().setAppName("BinaryClassificationMetricsExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_binary_classification_data.txt");
        RDD[] rDDArray = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        if (rDDArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)rDDArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
            throw new MatchError((Object)rDDArray);
        }
        RDD training = (RDD)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        RDD test = (RDD)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        Tuple2 tuple2 = new Tuple2((Object)training, (Object)test);
        RDD training2 = (RDD)tuple2._1();
        RDD test2 = (RDD)tuple2._2();
        training2.cache();
        LogisticRegressionModel model = new LogisticRegressionWithLBFGS().setNumClasses(2).run(training2);
        model.clearThreshold();
        RDD predictionAndLabels = test2.map((Function1 & Serializable)x0$1 -> {
            LabeledPoint labeledPoint = x0$1;
            if (labeledPoint != null) {
                double label = labeledPoint.label();
                Vector features = labeledPoint.features();
                double prediction = model.predict(features);
                return new Tuple2.mcDD.sp(prediction, label);
            }
            throw new MatchError((Object)labeledPoint);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(predictionAndLabels);
        RDD precision = metrics.precisionByThreshold();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])precision.collect()), (Function1 & Serializable)x0$2 -> {
            BinaryClassificationMetricsExample$.$anonfun$main$2(x0$2);
            return BoxedUnit.UNIT;
        });
        RDD recall = metrics.recallByThreshold();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])recall.collect()), (Function1 & Serializable)x0$3 -> {
            BinaryClassificationMetricsExample$.$anonfun$main$3(x0$3);
            return BoxedUnit.UNIT;
        });
        RDD PRC = metrics.pr();
        RDD f1Score = metrics.fMeasureByThreshold();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])f1Score.collect()), (Function1 & Serializable)x0$4 -> {
            BinaryClassificationMetricsExample$.$anonfun$main$4(x0$4);
            return BoxedUnit.UNIT;
        });
        double beta = 0.5;
        RDD fScore = metrics.fMeasureByThreshold(beta);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])fScore.collect()), (Function1 & Serializable)x0$5 -> {
            BinaryClassificationMetricsExample$.$anonfun$main$5(x0$5);
            return BoxedUnit.UNIT;
        });
        double auPRC = metrics.areaUnderPR();
        Predef$.MODULE$.println((Object)("Area under precision-recall curve = " + auPRC));
        RDD thresholds = precision.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2._1$mcD$sp()), (ClassTag)ClassTag$.MODULE$.Double());
        RDD roc = metrics.roc();
        double auROC = metrics.areaUnderROC();
        Predef$.MODULE$.println((Object)("Area under ROC = " + auROC));
        sc.stop();
    }

    public static final /* synthetic */ void $anonfun$main$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            double t = tuple2._1$mcD$sp();
            double p = tuple2._2$mcD$sp();
            Predef$.MODULE$.println((Object)("Threshold: " + t + ", Precision: " + p));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$main$3(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            double t = tuple2._1$mcD$sp();
            double r = tuple2._2$mcD$sp();
            Predef$.MODULE$.println((Object)("Threshold: " + t + ", Recall: " + r));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$main$4(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            double t = tuple2._1$mcD$sp();
            double f = tuple2._2$mcD$sp();
            Predef$.MODULE$.println((Object)("Threshold: " + t + ", F-score: " + f + ", Beta = 1"));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$main$5(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            double t = tuple2._1$mcD$sp();
            double f = tuple2._2$mcD$sp();
            Predef$.MODULE$.println((Object)("Threshold: " + t + ", F-score: " + f + ", Beta = 0.5"));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private BinaryClassificationMetricsExample$() {
    }
}

