/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.OffsetAndTimestampInternal;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;

public class ListOffsetsEvent
extends CompletableApplicationEvent<Map<TopicPartition, OffsetAndTimestampInternal>> {
    private final Map<TopicPartition, Long> timestampsToSearch;
    private final boolean requireTimestamps;

    public ListOffsetsEvent(Map<TopicPartition, Long> timestampToSearch, long deadlineMs, boolean requireTimestamps) {
        super(ApplicationEvent.Type.LIST_OFFSETS, deadlineMs);
        this.timestampsToSearch = Collections.unmodifiableMap(timestampToSearch);
        this.requireTimestamps = requireTimestamps;
    }

    public <T> Map<TopicPartition, T> emptyResults() {
        HashMap result = new HashMap();
        this.timestampsToSearch.keySet().forEach(tp -> result.put(tp, null));
        return result;
    }

    public Map<TopicPartition, Long> timestampsToSearch() {
        return this.timestampsToSearch;
    }

    public boolean requireTimestamps() {
        return this.requireTimestamps;
    }

    @Override
    public String toStringBase() {
        return super.toStringBase() + ", timestampsToSearch=" + this.timestampsToSearch + ", requireTimestamps=" + this.requireTimestamps;
    }
}

