/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.dto;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;

public class ApolloNotificationMessages {
    private Map<String, Long> details;

    public ApolloNotificationMessages() {
        this(Maps.newHashMap());
    }

    private ApolloNotificationMessages(Map<String, Long> details) {
        this.details = details;
    }

    public void put(String key, long notificationId) {
        this.details.put(key, notificationId);
    }

    public Long get(String key) {
        return this.details.get(key);
    }

    public boolean has(String key) {
        return this.details.containsKey(key);
    }

    public boolean isEmpty() {
        return this.details.isEmpty();
    }

    public Map<String, Long> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, Long> details) {
        this.details = details;
    }

    public void mergeFrom(ApolloNotificationMessages source) {
        if (source == null) {
            return;
        }
        for (Map.Entry<String, Long> entry : source.getDetails().entrySet()) {
            if (this.has(entry.getKey()) && this.get(entry.getKey()) >= entry.getValue()) continue;
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public ApolloNotificationMessages clone() {
        return new ApolloNotificationMessages((Map<String, Long>)ImmutableMap.copyOf(this.details));
    }
}

