/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.auth;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.auth.BasicToken;
import com.linecorp.armeria.common.auth.OAuth1aToken;
import com.linecorp.armeria.common.auth.OAuth2Token;
import com.linecorp.armeria.server.auth.BasicTokenExtractor;
import com.linecorp.armeria.server.auth.OAuth1aTokenExtractor;
import com.linecorp.armeria.server.auth.OAuth2TokenExtractor;
import java.util.function.Function;

public final class AuthTokenExtractors {
    private static final Function<? super RequestHeaders, @Nullable BasicToken> BASIC = new BasicTokenExtractor(HttpHeaderNames.AUTHORIZATION);
    private static final Function<? super RequestHeaders, @Nullable OAuth1aToken> OAUTH1A = new OAuth1aTokenExtractor(HttpHeaderNames.AUTHORIZATION);
    private static final Function<? super RequestHeaders, @Nullable OAuth2Token> OAUTH2 = new OAuth2TokenExtractor(HttpHeaderNames.AUTHORIZATION);

    public static Function<? super RequestHeaders, @Nullable BasicToken> basic() {
        return BASIC;
    }

    public static Function<? super RequestHeaders, @Nullable OAuth1aToken> oAuth1a() {
        return OAUTH1A;
    }

    public static Function<? super RequestHeaders, @Nullable OAuth2Token> oAuth2() {
        return OAUTH2;
    }

    private AuthTokenExtractors() {
    }
}

