/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.common.AbstractHttp2ConnectionHandlerBuilder;
import com.linecorp.armeria.server.GracefulShutdownSupport;
import com.linecorp.armeria.server.Http2ServerConnectionHandler;
import com.linecorp.armeria.server.ServerConfig;
import io.micrometer.core.instrument.Timer;
import io.netty.channel.Channel;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.AsciiString;

final class Http2ServerConnectionHandlerBuilder
extends AbstractHttp2ConnectionHandlerBuilder<Http2ServerConnectionHandler, Http2ServerConnectionHandlerBuilder> {
    private final ServerConfig config;
    private final Timer keepAliveTimer;
    private final GracefulShutdownSupport gracefulShutdownSupport;
    private final AsciiString scheme;

    Http2ServerConnectionHandlerBuilder(Channel ch, ServerConfig config, Timer keepAliveTimer, GracefulShutdownSupport gracefulShutdownSupport, AsciiString scheme) {
        super(ch);
        this.config = config;
        this.keepAliveTimer = keepAliveTimer;
        this.gracefulShutdownSupport = gracefulShutdownSupport;
        this.scheme = scheme;
        this.gracefulShutdownTimeoutMillis(-1L);
        this.decoderEnforceMaxRstFramesPerWindow(config.http2MaxResetFramesPerWindow(), config.http2MaxResetFramesWindowSeconds());
    }

    @Override
    protected Http2ServerConnectionHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) throws Exception {
        return new Http2ServerConnectionHandler(decoder, encoder, initialSettings, this.channel(), this.config, this.keepAliveTimer, this.gracefulShutdownSupport, this.scheme);
    }
}

