/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.crypto.generators;

import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.KeyGenerationParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.ECDomainParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECConstants;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECMultiplier;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECPoint;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.WNafUtil;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while ((bigInteger = BigIntegers.createRandomBigInteger(n, this.random)).compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

