/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.logging;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.logging.LogWriter;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.TransientServiceOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingUtils {
    private static final Logger logger = LoggerFactory.getLogger(LoggingUtils.class);

    public static void log(RequestContext ctx, RequestLog requestLog, LogWriter logWriter) {
        if (requestLog.requestCause() != null || !LoggingUtils.isTransientService(ctx)) {
            try {
                logWriter.logRequest(requestLog);
            }
            catch (Throwable t) {
                LoggingUtils.logException(ctx, "request", t);
            }
        }
        if (requestLog.responseCause() != null || requestLog.responseHeaders().status().isServerError() || !LoggingUtils.isTransientService(ctx)) {
            try {
                logWriter.logResponse(requestLog);
            }
            catch (Throwable t) {
                LoggingUtils.logException(ctx, "response", t);
            }
        }
    }

    private static void logException(RequestContext ctx, String requestOrResponse, Throwable cause) {
        try (SafeCloseable ignored = ctx.push();){
            logger.warn("{} Unexpected exception while logging {}: ", ctx, requestOrResponse, cause);
        }
    }

    private static boolean isTransientService(RequestContext ctx) {
        return ctx instanceof ServiceRequestContext && !((ServiceRequestContext)ctx).config().transientServiceOptions().contains((Object)TransientServiceOption.WITH_SERVICE_LOGGING);
    }

    private LoggingUtils() {
    }
}

