/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.multipart;

import com.google.errorprone.annotations.CheckReturnValue;
import com.linecorp.armeria.common.ContentDisposition;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.multipart.AggregatedBodyPart;
import com.linecorp.armeria.common.multipart.BodyPartBuilder;
import com.linecorp.armeria.common.stream.ByteStreamMessage;
import com.linecorp.armeria.common.stream.StreamMessage;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.EventExecutor;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;

public interface BodyPart {
    public static BodyPart of(ContentDisposition contentDisposition, CharSequence content) {
        Objects.requireNonNull(content, "content");
        return BodyPart.of(contentDisposition, HttpData.ofUtf8(content));
    }

    public static BodyPart of(ContentDisposition contentDisposition, MediaType contentType, CharSequence content) {
        Objects.requireNonNull(content, "content");
        return BodyPart.of(contentDisposition, contentType, HttpData.ofUtf8(content));
    }

    public static BodyPart of(HttpHeaders headers, CharSequence content) {
        Objects.requireNonNull(content, "content");
        return BodyPart.of(headers, HttpData.ofUtf8(content));
    }

    public static BodyPart of(ContentDisposition contentDisposition, HttpData content) {
        Objects.requireNonNull(content, "content");
        return BodyPart.of(contentDisposition, StreamMessage.of(content));
    }

    public static BodyPart of(ContentDisposition contentDisposition, MediaType contentType, HttpData content) {
        Objects.requireNonNull(content, "content");
        return BodyPart.of(contentDisposition, contentType, StreamMessage.of(content));
    }

    public static BodyPart of(HttpHeaders headers, HttpData content) {
        Objects.requireNonNull(content, "content");
        return BodyPart.of(headers, StreamMessage.of(content));
    }

    public static BodyPart of(ContentDisposition contentDisposition, Publisher<? extends HttpData> publisher) {
        HttpHeaders headers = HttpHeaders.builder().contentDisposition(contentDisposition).build();
        return BodyPart.of(headers, publisher);
    }

    public static BodyPart of(ContentDisposition contentDisposition, MediaType contentType, Publisher<? extends HttpData> publisher) {
        Objects.requireNonNull(contentDisposition, "contentDisposition");
        Objects.requireNonNull(contentType, "contentType");
        Objects.requireNonNull(publisher, "publisher");
        HttpHeaders headers = HttpHeaders.builder().contentDisposition(contentDisposition).contentType(contentType).build();
        return BodyPart.of(headers, publisher);
    }

    public static BodyPart of(HttpHeaders headers, Publisher<? extends HttpData> publisher) {
        return BodyPart.builder().headers(headers).content(publisher).build();
    }

    public static BodyPartBuilder builder() {
        return new BodyPartBuilder();
    }

    public HttpHeaders headers();

    @CheckReturnValue
    public ByteStreamMessage content();

    public CompletableFuture<Void> writeTo(Path var1, EventExecutor var2, ExecutorService var3, OpenOption ... var4);

    public CompletableFuture<Void> writeTo(Path var1, OpenOption ... var2);

    public CompletableFuture<AggregatedBodyPart> aggregate();

    public CompletableFuture<AggregatedBodyPart> aggregate(EventExecutor var1);

    public CompletableFuture<AggregatedBodyPart> aggregateWithPooledObjects(ByteBufAllocator var1);

    public CompletableFuture<AggregatedBodyPart> aggregateWithPooledObjects(EventExecutor var1, ByteBufAllocator var2);

    @Nullable
    default public String name() {
        ContentDisposition contentDisposition = this.headers().contentDisposition();
        if (contentDisposition != null) {
            return contentDisposition.name();
        }
        return null;
    }

    @Nullable
    default public String filename() {
        ContentDisposition contentDisposition = this.headers().contentDisposition();
        if (contentDisposition != null) {
            return contentDisposition.filename();
        }
        return null;
    }
}

