/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.trace;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.analysis.worker.NoneStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@ScopeDeclaration(id=26, name="ProfileTask")
@Stream(name="profile_task", scopeId=26, builder=Builder.class, processor=NoneStreamProcessor.class)
@BanyanDB.TimestampColumn(value="start_time")
@BanyanDB.Group(streamGroup=BanyanDB.StreamGroup.RECORDS)
public class ProfileTaskRecord
extends NoneStream {
    public static final String INDEX_NAME = "profile_task";
    public static final String TASK_ID = "task_id";
    public static final String SERVICE_ID = "service_id";
    public static final String ENDPOINT_NAME = "endpoint_name";
    public static final String START_TIME = "start_time";
    public static final String DURATION = "duration";
    public static final String MIN_DURATION_THRESHOLD = "min_duration_threshold";
    public static final String DUMP_PERIOD = "dump_period";
    public static final String CREATE_TIME = "create_time";
    public static final String MAX_SAMPLING_COUNT = "max_sampling_count";
    @Column(name="service_id")
    @BanyanDB.SeriesID(index=0)
    private String serviceId;
    @Column(name="endpoint_name", length=512)
    private String endpointName;
    @Column(name="task_id")
    private String taskId;
    @ElasticSearch.EnableDocValues
    @Column(name="start_time")
    private long startTime;
    @Column(name="duration")
    private int duration;
    @Column(name="min_duration_threshold")
    private int minDurationThreshold;
    @Column(name="dump_period")
    private int dumpPeriod;
    @ElasticSearch.EnableDocValues
    @Column(name="create_time")
    private long createTime;
    @Column(name="max_sampling_count")
    private int maxSamplingCount;

    @Override
    public StorageID id() {
        return new StorageID().append(TASK_ID, this.taskId);
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getEndpointName() {
        return this.endpointName;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Generated
    public int getMinDurationThreshold() {
        return this.minDurationThreshold;
    }

    @Generated
    public int getDumpPeriod() {
        return this.dumpPeriod;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public int getMaxSamplingCount() {
        return this.maxSamplingCount;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Generated
    public void setMinDurationThreshold(int minDurationThreshold) {
        this.minDurationThreshold = minDurationThreshold;
    }

    @Generated
    public void setDumpPeriod(int dumpPeriod) {
        this.dumpPeriod = dumpPeriod;
    }

    @Generated
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setMaxSamplingCount(int maxSamplingCount) {
        this.maxSamplingCount = maxSamplingCount;
    }

    public static class Builder
    implements StorageBuilder<ProfileTaskRecord> {
        @Override
        public ProfileTaskRecord storage2Entity(Convert2Entity converter) {
            ProfileTaskRecord record = new ProfileTaskRecord();
            record.setServiceId((String)converter.get(ProfileTaskRecord.SERVICE_ID));
            record.setEndpointName((String)converter.get(ProfileTaskRecord.ENDPOINT_NAME));
            record.setTaskId((String)converter.get(ProfileTaskRecord.TASK_ID));
            record.setStartTime(((Number)converter.get(ProfileTaskRecord.START_TIME)).longValue());
            record.setDuration(((Number)converter.get(ProfileTaskRecord.DURATION)).intValue());
            record.setMinDurationThreshold(((Number)converter.get(ProfileTaskRecord.MIN_DURATION_THRESHOLD)).intValue());
            record.setDumpPeriod(((Number)converter.get(ProfileTaskRecord.DUMP_PERIOD)).intValue());
            record.setCreateTime(((Number)converter.get(ProfileTaskRecord.CREATE_TIME)).longValue());
            record.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            record.setMaxSamplingCount(((Number)converter.get(ProfileTaskRecord.MAX_SAMPLING_COUNT)).intValue());
            return record;
        }

        @Override
        public void entity2Storage(ProfileTaskRecord storageData, Convert2Storage converter) {
            converter.accept(ProfileTaskRecord.SERVICE_ID, storageData.getServiceId());
            converter.accept(ProfileTaskRecord.ENDPOINT_NAME, storageData.getEndpointName());
            converter.accept(ProfileTaskRecord.TASK_ID, storageData.getTaskId());
            converter.accept(ProfileTaskRecord.START_TIME, storageData.getStartTime());
            converter.accept(ProfileTaskRecord.DURATION, storageData.getDuration());
            converter.accept(ProfileTaskRecord.MIN_DURATION_THRESHOLD, storageData.getMinDurationThreshold());
            converter.accept(ProfileTaskRecord.DUMP_PERIOD, storageData.getDumpPeriod());
            converter.accept(ProfileTaskRecord.CREATE_TIME, storageData.getCreateTime());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept(ProfileTaskRecord.MAX_SAMPLING_COUNT, storageData.getMaxSamplingCount());
        }
    }
}

