/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.config.group.openapi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.config.group.openapi.EndpointGroupingRule4Openapi;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class EndpointGroupingRuleReader4Openapi {
    private final Map<String, List<Map>> serviceOpenapiDefMap;
    private static final String DEFAULT_ENDPOINT_NAME_FORMAT = "${METHOD}:${PATH}";
    private static final String DEFAULT_ENDPOINT_NAME_MATCH_RULE = "${METHOD}:${PATH}";
    private final Map<String, String> requestMethodsMap = new HashMap<String, String>(){
        {
            this.put("get", "GET");
            this.put("post", "POST");
            this.put("put", "PUT");
            this.put("delete", "DELETE");
            this.put("trace", "TRACE");
            this.put("options", "OPTIONS");
            this.put("head", "HEAD");
            this.put("patch", "PATCH");
        }
    };

    public EndpointGroupingRuleReader4Openapi(String openapiDefPath) throws FileNotFoundException {
        this.serviceOpenapiDefMap = this.parseFromDir(openapiDefPath);
    }

    public EndpointGroupingRuleReader4Openapi(Map<String, String> openapiDefsConf) {
        this.serviceOpenapiDefMap = this.parseFromDynamicConf(openapiDefsConf);
    }

    public EndpointGroupingRule4Openapi read() {
        EndpointGroupingRule4Openapi endpointGroupingRule = new EndpointGroupingRule4Openapi();
        this.serviceOpenapiDefMap.forEach((serviceName, openapiDefs) -> openapiDefs.forEach(openapiData -> {
            LinkedHashMap paths = (LinkedHashMap)openapiData.get("paths");
            if (paths != null) {
                paths.forEach((pathString, pathItem) -> pathItem.keySet().forEach(key -> {
                    String requestMethod = this.requestMethodsMap.get(key);
                    if (!StringUtil.isEmpty((String)requestMethod)) {
                        String endpointGroupName = this.formatEndPointName((String)pathString, requestMethod, (Map)openapiData);
                        String groupRegex = this.getGroupRegex((String)pathString, requestMethod, (Map)openapiData);
                        if (this.isTemplatePath((String)pathString)) {
                            endpointGroupingRule.addGroupedRule((String)serviceName, endpointGroupName, groupRegex);
                        } else {
                            endpointGroupingRule.addDirectLookup((String)serviceName, groupRegex, endpointGroupName);
                        }
                    }
                }));
            }
        }));
        endpointGroupingRule.sortRulesAll();
        return endpointGroupingRule;
    }

    private Map<String, List<Map>> parseFromDir(String openapiDefPath) throws FileNotFoundException {
        HashMap<String, List<Map>> serviceOpenapiDefMap = new HashMap<String, List<Map>>();
        List fileList = ResourceUtils.getDirectoryFilesRecursive((String)openapiDefPath, (int)1);
        for (File file : fileList) {
            FileReader reader;
            Yaml yaml;
            Map openapiData;
            if (!file.getName().endsWith(".yaml") || (openapiData = (Map)(yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()))).load((Reader)(reader = new FileReader(file)))) == null) continue;
            serviceOpenapiDefMap.computeIfAbsent(this.getServiceName(openapiDefPath, file, openapiData), k -> new ArrayList()).add(openapiData);
        }
        return serviceOpenapiDefMap;
    }

    private Map<String, List<Map>> parseFromDynamicConf(Map<String, String> openapiDefsConf) {
        HashMap<String, List<Map>> serviceOpenapiDefMap = new HashMap<String, List<Map>>();
        openapiDefsConf.forEach((itemName, openapiDefs) -> {
            StringReader reader;
            Yaml yaml;
            Map openapiData;
            String serviceName = itemName;
            String[] itemNameInfo = itemName.split("\\.");
            if (itemNameInfo.length > 1) {
                serviceName = itemNameInfo[0];
            }
            if ((openapiData = (Map)(yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()))).load((Reader)(reader = new StringReader((String)openapiDefs)))) != null) {
                serviceOpenapiDefMap.computeIfAbsent(this.getServiceName(serviceName, openapiData), k -> new ArrayList()).add(openapiData);
            }
        });
        return serviceOpenapiDefMap;
    }

    private String getServiceName(String openapiDefPath, File file, Map openapiData) {
        String serviceName = (String)openapiData.get("x-sw-service-name");
        if (StringUtil.isEmpty((String)serviceName)) {
            File directory = new File(file.getParent());
            if (openapiDefPath.equals(directory.getName())) {
                throw new IllegalArgumentException("OpenAPI definition file: " + file.getAbsolutePath() + " found in root directory, but doesn't include x-sw-service-name extensive definition in the file.");
            }
            serviceName = directory.getName();
        }
        return serviceName;
    }

    private String getServiceName(String defaultServiceName, Map openapiData) {
        String serviceName = (String)openapiData.get("x-sw-service-name");
        if (StringUtil.isEmpty((String)serviceName)) {
            serviceName = defaultServiceName;
        }
        return serviceName;
    }

    private boolean isTemplatePath(String pathString) {
        return pathString.matches("(.*)\\{(.+?)}(.*)");
    }

    private String getGroupRegex(String pathString, String requstMathod, Map openapiData) {
        String endPointNameMatchRuleTemplate = (String)openapiData.get("x-sw-endpoint-name-match-rule");
        String endPointNameMatchRule = this.replaceTemplateVars("${METHOD}:${PATH}", pathString, requstMathod);
        if (!StringUtil.isEmpty((String)endPointNameMatchRuleTemplate)) {
            endPointNameMatchRule = this.replaceTemplateVars(endPointNameMatchRuleTemplate, pathString, requstMathod);
        }
        if (this.isTemplatePath(endPointNameMatchRule)) {
            return endPointNameMatchRule.replaceAll("\\{(.+?)}", "([^/]+)");
        }
        return endPointNameMatchRule;
    }

    private String formatEndPointName(String pathString, String requstMethod, Map openapiData) {
        String endPointNameFormat = (String)openapiData.get("x-sw-endpoint-name-format");
        if (!StringUtil.isEmpty((String)endPointNameFormat)) {
            return this.replaceTemplateVars(endPointNameFormat, pathString, requstMethod);
        }
        return this.replaceTemplateVars("${METHOD}:${PATH}", pathString, requstMethod);
    }

    private String replaceTemplateVars(String template, String pathString, String requstMathod) {
        return template.replaceAll("\\$\\{METHOD}", requstMathod).replaceAll("\\$\\{PATH}", pathString);
    }
}

