/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.ebpf.provider.handler;

import io.grpc.stub.StreamObserver;
import io.vavr.Tuple2;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.aop.server.receiver.mesh.TelemetryDataDispatcher;
import org.apache.skywalking.apm.network.common.v3.DetectPoint;
import org.apache.skywalking.apm.network.common.v3.Instant;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.AccessLogConnection;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.AccessLogConnectionTLSMode;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.AccessLogHTTPProtocol;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.AccessLogKernelAcceptOperation;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.AccessLogKernelCloseOperation;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.AccessLogKernelConnectOperation;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.AccessLogKernelLog;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.AccessLogKernelReadOperation;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.AccessLogKernelWriteOperation;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.AccessLogProtocolLogs;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.AccessLogProtocolType;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.ConnectionAddress;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.EBPFAccessLogDownstream;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.EBPFAccessLogMessage;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.EBPFAccessLogNodeInfo;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.EBPFAccessLogNodeNetInterface;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.EBPFAccessLogServiceGrpc;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.EBPFTimestamp;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.IPAddress;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.KubernetesProcessAddress;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.ZTunnelAttachmentEnvironment;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.ZTunnelAttachmentEnvironmentDetectBy;
import org.apache.skywalking.apm.network.ebpf.accesslog.v3.ZTunnelAttachmentSecurityPolicy;
import org.apache.skywalking.apm.network.servicemesh.v3.HTTPServiceMeshMetric;
import org.apache.skywalking.apm.network.servicemesh.v3.HTTPServiceMeshMetrics;
import org.apache.skywalking.apm.network.servicemesh.v3.Protocol;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetrics;
import org.apache.skywalking.apm.network.servicemesh.v3.TCPServiceMeshMetric;
import org.apache.skywalking.apm.network.servicemesh.v3.TCPServiceMeshMetrics;
import org.apache.skywalking.library.kubernetes.ObjectID;
import org.apache.skywalking.oap.meter.analyzer.k8s.K8sInfoRegistry;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.K8SEndpoint;
import org.apache.skywalking.oap.server.core.source.K8SMetrics;
import org.apache.skywalking.oap.server.core.source.K8SService;
import org.apache.skywalking.oap.server.core.source.K8SServiceInstance;
import org.apache.skywalking.oap.server.core.source.K8SServiceInstanceRelation;
import org.apache.skywalking.oap.server.core.source.K8SServiceRelation;
import org.apache.skywalking.oap.server.core.source.Service;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.ebpf.provider.handler.address.K8sProcessAddress;
import org.apache.skywalking.oap.server.receiver.ebpf.provider.handler.address.ProcessAddress;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogServiceHandler
extends EBPFAccessLogServiceGrpc.EBPFAccessLogServiceImplBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccessLogServiceHandler.class);
    protected static final ProcessAddress UNKNOWN_ADDRESS = new K8sProcessAddress(KubernetesProcessAddress.newBuilder().setServiceName("Unknown").setPodName("Unknown").build());
    protected final SourceReceiver sourceReceiver;
    protected final NamingControl namingControl;
    private final CounterMetrics inCounter;
    private final CounterMetrics errorStreamCounter;
    private final HistogramMetrics processHistogram;
    private final CounterMetrics dropCounter;
    private final ConcurrentHashMap<String, DropDataReason> dropReasons = new ConcurrentHashMap();

    public AccessLogServiceHandler(ModuleManager moduleManager) {
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        TelemetryDataDispatcher.init((ModuleManager)moduleManager);
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.inCounter = metricsCreator.createCounter("k8s_als_in_count", "The count of eBPF log entries received", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.errorStreamCounter = metricsCreator.createCounter("k8s_als_error_streams", "The error count of eBPF log streams that OAP failed to process", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.processHistogram = metricsCreator.createHistogramMetric("k8s_als_in_latency", "The processing latency of eBPF log streams", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
        this.dropCounter = metricsCreator.createCounter("k8s_als_drop_count", "The count of eBPF log entries dropped", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this::printDropReasons, 10L, 10L, TimeUnit.SECONDS);
    }

    public StreamObserver<EBPFAccessLogMessage> collect(final StreamObserver<EBPFAccessLogDownstream> responseObserver) {
        return new StreamObserver<EBPFAccessLogMessage>(){
            private volatile boolean isFirst = true;
            private NodeInfo node;
            private volatile ConnectionInfo connection;

            public void onNext(EBPFAccessLogMessage logMessage) {
                try (HistogramMetrics.Timer ignored = AccessLogServiceHandler.this.processHistogram.createTimer();){
                    if (this.isFirst || logMessage.hasNode()) {
                        this.isFirst = false;
                        this.node = new NodeInfo(logMessage.getNode());
                    }
                    if (logMessage.hasConnection()) {
                        this.connection = new ConnectionInfo(AccessLogServiceHandler.this.namingControl, this.node, logMessage.getConnection());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("messaged is identified from eBPF node[{}], connection[{}]. Received msg {}", new Object[]{this.node, this.connection, logMessage});
                    }
                    if (this.connection == null || !this.connection.isValid()) {
                        AccessLogServiceHandler.this.dropCounter.inc((double)(logMessage.getKernelLogsCount() + (logMessage.hasProtocolLog() ? 1 : 0)));
                        return;
                    }
                    AccessLogServiceHandler.this.prepareForDispatch(this.node, this.connection, logMessage);
                    for (AccessLogKernelLog accessLogKernelLog : logMessage.getKernelLogsList()) {
                        AccessLogServiceHandler.this.inCounter.inc();
                        AccessLogServiceHandler.this.dispatchKernelLog(this.node, this.connection, accessLogKernelLog);
                    }
                    if (logMessage.hasProtocolLog()) {
                        AccessLogServiceHandler.this.inCounter.inc();
                        AccessLogServiceHandler.this.dispatchProtocolLog(this.node, this.connection, logMessage.getKernelLogsList(), logMessage.getProtocolLog());
                    }
                }
                catch (Exception e) {
                    log.error("Access log service handler process error.", (Throwable)e);
                    AccessLogServiceHandler.this.errorStreamCounter.inc();
                }
            }

            public void onError(Throwable throwable) {
                log.warn("Access log service handler error.", throwable);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)EBPFAccessLogDownstream.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }

    protected void prepareForDispatch(NodeInfo node, ConnectionInfo connection, EBPFAccessLogMessage logMessage) {
        if (connection.getOriginalConnection().hasAttachment() && connection.getOriginalConnection().getAttachment().hasZTunnel()) {
            this.prepareDispatchForZtunnelMesh(node, connection, logMessage);
        }
    }

    protected void prepareDispatchForZtunnelMesh(NodeInfo node, ConnectionInfo connection, EBPFAccessLogMessage logMessage) {
        K8SServiceRelation serviceRelation = connection.toServiceRelation();
        this.buildBaseServiceFromRelation(serviceRelation, Layer.MESH).forEach(arg_0 -> ((SourceReceiver)this.sourceReceiver).receive(arg_0));
        String tlsMode = "NONE";
        if (AccessLogConnectionTLSMode.TLS.equals((Object)connection.getTlsMode())) {
            tlsMode = "TLS";
        }
        if (ZTunnelAttachmentSecurityPolicy.MTLS.equals((Object)connection.getOriginalConnection().getAttachment().getZTunnel().getSecurityPolicy())) {
            tlsMode = "mTLS";
        }
        if (logMessage.hasProtocolLog()) {
            AccessLogProtocolLogs protocolLog = logMessage.getProtocolLog();
            ServiceMeshMetrics.Builder serviceMeshMetrics = ServiceMeshMetrics.newBuilder();
            switch (protocolLog.getProtocolCase()) {
                case HTTP: {
                    serviceMeshMetrics.setHttpMetrics(HTTPServiceMeshMetrics.newBuilder().addMetrics(this.generateHTTPServiceMeshMetrics(node, connection, protocolLog.getHttp(), tlsMode)));
                }
            }
            TelemetryDataDispatcher.process((ServiceMeshMetrics)serviceMeshMetrics.build());
        }
        ServiceMeshMetrics.Builder serviceMeshMetrics = ServiceMeshMetrics.newBuilder();
        TCPServiceMeshMetrics.Builder builder = TCPServiceMeshMetrics.newBuilder();
        for (AccessLogKernelLog accessLogKernelLog : logMessage.getKernelLogsList()) {
            Optional.ofNullable(this.generateTCPServiceMeshMetrics(node, connection, accessLogKernelLog, tlsMode)).ifPresent(arg_0 -> ((TCPServiceMeshMetrics.Builder)builder).addMetrics(arg_0));
        }
        serviceMeshMetrics.setTcpMetrics(builder.build());
        TelemetryDataDispatcher.process((ServiceMeshMetrics)serviceMeshMetrics.build());
    }

    protected HTTPServiceMeshMetric generateHTTPServiceMeshMetrics(NodeInfo node, ConnectionInfo connection, AccessLogHTTPProtocol http, String tlsMode) {
        ProcessAddress dest;
        ProcessAddress source;
        if (DetectPoint.client.equals((Object)connection.getRole())) {
            source = connection.getLocal();
            dest = connection.getRemote();
        } else {
            source = connection.getRemote();
            dest = connection.getLocal();
        }
        long startTime = node.parseTimestamp(http.getStartTime());
        long endTime = node.parseTimestamp(http.getEndTime());
        return HTTPServiceMeshMetric.newBuilder().setStartTime(startTime).setEndTime(endTime).setSourceServiceName(this.buildServiceNameByAddress(node, source)).setSourceServiceInstance(this.buildServiceInstanceName(source)).setDestServiceName(this.buildServiceNameByAddress(node, dest)).setDestServiceInstance(this.buildServiceInstanceName(dest)).setEndpoint(this.buildHTTPProtocolEndpointName(connection, http)).setLatency((int)(endTime - startTime)).setResponseCode(http.getResponse().getStatusCode()).setStatus(http.getResponse().getStatusCode() < 500).setProtocol(Protocol.HTTP).setDetectPoint(connection.getRole()).setTlsMode(tlsMode).build();
    }

    protected TCPServiceMeshMetric generateTCPServiceMeshMetrics(NodeInfo node, ConnectionInfo connection, AccessLogKernelLog kernelLog, String tlsMode) {
        ProcessAddress dest;
        ProcessAddress source;
        long receivedBytes = 0L;
        long sentBytes = 0L;
        long startTime = 0L;
        long endTime = 0L;
        switch (kernelLog.getOperationCase()) {
            case CONNECT: 
            case ACCEPT: 
            case CLOSE: {
                return null;
            }
            case WRITE: {
                AccessLogKernelWriteOperation write = kernelLog.getWrite();
                sentBytes = write.getL4Metrics().getTotalPackageSize();
                startTime = node.parseTimestamp(write.getStartTime());
                endTime = node.parseTimestamp(write.getEndTime());
                break;
            }
            case READ: {
                AccessLogKernelReadOperation read = kernelLog.getRead();
                receivedBytes = read.getL2Metrics().getTotalPackageSize();
                startTime = node.parseTimestamp(read.getStartTime());
                endTime = node.parseTimestamp(read.getEndTime());
            }
        }
        if (DetectPoint.client.equals((Object)connection.getRole())) {
            source = connection.getLocal();
            dest = connection.getRemote();
        } else {
            source = connection.getRemote();
            dest = connection.getLocal();
        }
        return TCPServiceMeshMetric.newBuilder().setStartTime(startTime).setEndTime(endTime).setSourceServiceName(this.buildServiceNameByAddress(node, source)).setSourceServiceInstance(this.buildServiceInstanceName(source)).setDestServiceName(this.buildServiceNameByAddress(node, dest)).setDestServiceInstance(this.buildServiceInstanceName(dest)).setDetectPoint(connection.getRole()).setTlsMode(tlsMode).setReceivedBytes(receivedBytes).setSentBytes(sentBytes).build();
    }

    protected List<K8SMetrics> buildKernelLogMetrics(NodeInfo node, ConnectionInfo connection, AccessLogKernelLog kernelLog) {
        return Arrays.asList(connection.toService(), connection.toServiceInstance(), connection.toServiceRelation(), connection.toServiceInstanceRelation());
    }

    protected List<K8SMetrics> buildProtocolServiceWithInstanceMetrics(NodeInfo node, ConnectionInfo connection, List<AccessLogKernelLog> relatedKernelLogs, AccessLogProtocolLogs protocolLog) {
        return Arrays.asList(connection.toService(), connection.toServiceInstance(), connection.toServiceRelation(), connection.toServiceInstanceRelation());
    }

    protected List<K8SMetrics.ProtocolMetrics> buildProtocolEndpointMetrics(NodeInfo node, ConnectionInfo connection, String endpointName, List<AccessLogKernelLog> relatedKernelLogs, AccessLogProtocolLogs protocolLog, boolean success, long duration) {
        return Collections.singletonList(connection.toEndpoint(endpointName, success, duration));
    }

    protected void dispatchKernelLog(NodeInfo node, ConnectionInfo connection, AccessLogKernelLog kernelLog) {
        List metrics = this.buildKernelLogMetrics(node, connection, kernelLog).stream().filter(Objects::nonNull).collect(Collectors.toList());
        for (K8SMetrics metric : metrics) {
            switch (kernelLog.getOperationCase()) {
                case CONNECT: {
                    AccessLogKernelConnectOperation connect = kernelLog.getConnect();
                    metric.setTimeBucket(node.parseMinuteTimeBucket(connect.getStartTime()));
                    metric.setType("connect");
                    metric.setConnect(new K8SMetrics.Connect());
                    metric.getConnect().setDuration(this.getDurationFromTimestamp(node, connect.getStartTime(), connect.getEndTime()));
                    metric.getConnect().setSuccess(connect.getSuccess());
                    break;
                }
                case ACCEPT: {
                    AccessLogKernelAcceptOperation accept = kernelLog.getAccept();
                    metric.setTimeBucket(node.parseMinuteTimeBucket(accept.getStartTime()));
                    metric.setType("accept");
                    metric.setAccept(new K8SMetrics.Accept());
                    metric.getAccept().setDuration(this.getDurationFromTimestamp(node, accept.getStartTime(), accept.getEndTime()));
                    break;
                }
                case CLOSE: {
                    AccessLogKernelCloseOperation close = kernelLog.getClose();
                    metric.setTimeBucket(node.parseMinuteTimeBucket(close.getStartTime()));
                    metric.setType("close");
                    metric.setClose(new K8SMetrics.Close());
                    metric.getClose().setDuration(this.getDurationFromTimestamp(node, close.getStartTime(), close.getEndTime()));
                    metric.getClose().setSuccess(close.getSuccess());
                    break;
                }
                case READ: {
                    AccessLogKernelReadOperation read = kernelLog.getRead();
                    metric.setTimeBucket(node.parseMinuteTimeBucket(read.getStartTime()));
                    metric.setType("read");
                    metric.setRead(new K8SMetrics.Read());
                    metric.getRead().setDuration(this.getDurationFromTimestamp(node, read.getStartTime(), read.getEndTime()));
                    metric.getRead().setSyscall(read.getSyscall().name());
                    K8SMetrics.ReadL4 readL4 = new K8SMetrics.ReadL4();
                    metric.getRead().setL4(readL4);
                    readL4.setDuration(read.getL4Metrics().getTotalDuration());
                    K8SMetrics.ReadL3 readL3 = new K8SMetrics.ReadL3();
                    metric.getRead().setL3(readL3);
                    readL3.setDuration(read.getL3Metrics().getTotalDuration());
                    readL3.setRcvDuration(read.getL3Metrics().getTotalRecvDuration());
                    readL3.setLocalDuration(read.getL3Metrics().getTotalLocalDuration());
                    long totalWriteNetFilterCount = read.getL3Metrics().getTotalNetFilterCount();
                    if (totalWriteNetFilterCount > 0L) {
                        readL3.setNetFilterCount(totalWriteNetFilterCount);
                        readL3.setNetFilterDuration(read.getL3Metrics().getTotalNetFilterDuration());
                    }
                    K8SMetrics.ReadL2 readL2 = new K8SMetrics.ReadL2();
                    metric.getRead().setL2(readL2);
                    readL2.setNetDeviceName(node.getNetInterfaceName(read.getL2Metrics().getIfindex()));
                    readL2.setPackageCount((long)read.getL2Metrics().getTotalPackageCount());
                    readL2.setTotalPackageSize(read.getL2Metrics().getTotalPackageSize());
                    readL2.setPackageToQueueDuration(read.getL2Metrics().getTotalPackageToQueueDuration());
                    readL2.setRcvPackageFromQueueDuration(read.getL2Metrics().getTotalRcvPackageFromQueueDuration());
                    break;
                }
                case WRITE: {
                    long totalReadNetFilterCount;
                    AccessLogKernelWriteOperation write = kernelLog.getWrite();
                    metric.setTimeBucket(node.parseMinuteTimeBucket(write.getStartTime()));
                    metric.setType("write");
                    metric.setWrite(new K8SMetrics.Write());
                    metric.getWrite().setDuration(this.getDurationFromTimestamp(node, write.getStartTime(), write.getEndTime()));
                    metric.getWrite().setSyscall(write.getSyscall().name());
                    K8SMetrics.WriteL4 writeL4 = new K8SMetrics.WriteL4();
                    metric.getWrite().setL4(writeL4);
                    writeL4.setDuration(write.getL4Metrics().getTotalDuration());
                    writeL4.setTransmitPackageCount(write.getL4Metrics().getTotalTransmitPackageCount());
                    writeL4.setRetransmitPackageCount(write.getL4Metrics().getTotalRetransmitPackageCount());
                    writeL4.setTotalPackageSize(write.getL4Metrics().getTotalPackageSize());
                    K8SMetrics.WriteL3 writeL3 = new K8SMetrics.WriteL3();
                    metric.getWrite().setL3(writeL3);
                    writeL3.setDuration(write.getL3Metrics().getTotalDuration());
                    writeL3.setLocalDuration(write.getL3Metrics().getTotalLocalDuration());
                    writeL3.setOutputDuration(write.getL3Metrics().getTotalOutputDuration());
                    long totalResolveMACCount = write.getL3Metrics().getTotalResolveMACCount();
                    if (totalResolveMACCount > 0L) {
                        writeL3.setResolveMACCount(totalResolveMACCount);
                        writeL3.setResolveMACDuration(write.getL3Metrics().getTotalResolveMACDuration());
                    }
                    if ((totalReadNetFilterCount = write.getL3Metrics().getTotalNetFilterCount()) > 0L) {
                        writeL3.setNetFilterCount(totalReadNetFilterCount);
                        writeL3.setNetFilterDuration(write.getL3Metrics().getTotalNetFilterDuration());
                    }
                    K8SMetrics.WriteL2 writeL2 = new K8SMetrics.WriteL2();
                    metric.getWrite().setL2(writeL2);
                    writeL2.setDuration(write.getL2Metrics().getTotalDuration());
                    writeL2.setNetworkDeviceName(node.getNetInterfaceName(write.getL2Metrics().getIfindex()));
                    long totalEnterQueueBufferCount = write.getL2Metrics().getTotalEnterQueueBufferCount();
                    writeL2.setEnterQueueBufferCount(totalEnterQueueBufferCount);
                    writeL2.setReadySendDuration(write.getL2Metrics().getTotalReadySendDuration());
                    writeL2.setNetworkDeviceSendDuration(write.getL2Metrics().getTotalNetDeviceSendDuration());
                }
            }
            this.sourceReceiver.receive((ISource)metric);
        }
    }

    protected void dispatchProtocolLog(NodeInfo node, ConnectionInfo connection, List<AccessLogKernelLog> relatedKernelLogs, AccessLogProtocolLogs protocolLog) {
        long startTimeBucket = 0L;
        boolean success = false;
        long duration = 0L;
        K8SMetrics.Protocol protocol = new K8SMetrics.Protocol();
        switch (protocolLog.getProtocolCase()) {
            case HTTP: {
                AccessLogHTTPProtocol http = protocolLog.getHttp();
                success = http.getResponse().getStatusCode() < 500;
                startTimeBucket = node.parseMinuteTimeBucket(http.getStartTime());
                protocol.setType("http");
                protocol.setHttp(new K8SMetrics.ProtocolHTTP());
                protocol.setSuccess(success);
                duration = this.convertNsToMs(this.getDurationFromTimestamp(node, http.getStartTime(), http.getEndTime()));
                protocol.getHttp().setLatency(duration);
                protocol.getHttp().setUrl(http.getRequest().getPath());
                protocol.getHttp().setMethod(http.getRequest().getMethod().name());
                protocol.getHttp().setStatusCode(http.getResponse().getStatusCode());
                protocol.getHttp().setSizeOfRequestHeader(http.getRequest().getSizeOfHeadersBytes());
                protocol.getHttp().setSizeOfRequestBody(http.getRequest().getSizeOfBodyBytes());
                protocol.getHttp().setSizeOfResponseHeader(http.getResponse().getSizeOfHeadersBytes());
                protocol.getHttp().setSizeOfResponseBody(http.getResponse().getSizeOfBodyBytes());
            }
        }
        long finalStartTimeBucket = startTimeBucket;
        Stream.ofNullable(this.buildProtocolServiceWithInstanceMetrics(node, connection, relatedKernelLogs, protocolLog)).flatMap(Collection::stream).filter(Objects::nonNull).forEach(metric -> {
            metric.setType("protocol");
            metric.setProtocol(protocol);
            metric.setTimeBucket(finalStartTimeBucket);
            this.sourceReceiver.receive((ISource)metric);
        });
        String endpointName = this.buildProtocolEndpointName(connection, protocolLog);
        Stream.ofNullable(this.buildProtocolEndpointMetrics(node, connection, endpointName, relatedKernelLogs, protocolLog, success, duration)).flatMap(Collection::stream).filter(Objects::nonNull).forEach(metric -> {
            metric.setType(protocol.getType());
            metric.setHttp(protocol.getHttp());
            metric.setTimeBucket(finalStartTimeBucket);
            this.sourceReceiver.receive((ISource)metric);
        });
    }

    protected long getDurationFromTimestamp(NodeInfo nodeInfo, EBPFTimestamp start, EBPFTimestamp end) {
        return end.getOffset().getOffset() - start.getOffset().getOffset();
    }

    protected String buildServiceNameByAddress(NodeInfo nodeInfo, ProcessAddress address) {
        return this.namingControl.formatServiceName(address.getServiceName());
    }

    protected String buildServiceInstanceName(ProcessAddress address) {
        return this.namingControl.formatInstanceName(address.getInstanceName());
    }

    protected String buildProtocolEndpointName(ConnectionInfo connectionInfo, AccessLogProtocolLogs protocol) {
        switch (protocol.getProtocolCase()) {
            case HTTP: {
                return this.buildHTTPProtocolEndpointName(connectionInfo, protocol.getHttp());
            }
        }
        return null;
    }

    protected String buildHTTPProtocolEndpointName(ConnectionInfo connectionInfo, AccessLogHTTPProtocol http) {
        return this.namingControl.formatEndpointName(connectionInfo.buildLocalServiceName(), StringUtils.upperCase((String)http.getRequest().getMethod().name()) + ":" + http.getRequest().getPath());
    }

    protected void recordIgnoreSameService(String sourceService) {
        DropDataReason dropDataReason = this.dropReasons.computeIfAbsent(sourceService, key -> DropDataReason.buildWhenSameService(sourceService));
        dropDataReason.increaseCount();
    }

    protected void recordLessConnection(AccessLogConnection connection) {
        DropDataReason dropDataReason = this.dropReasons.computeIfAbsent(String.format("%s_%s", this.buildConnectionAddressString(connection.getLocal()), this.buildConnectionAddressString(connection.getRemote())), key -> DropDataReason.buildWhenConnectionLoss(connection));
        dropDataReason.increaseCount();
    }

    protected String buildConnectionAddressString(ConnectionAddress address) {
        switch (address.getAddressCase()) {
            case KUBERNETES: {
                return String.format("%s-%s-%s-%s", address.getKubernetes().getServiceName(), address.getKubernetes().getPodName(), address.getKubernetes().getContainerName(), address.getKubernetes().getProcessName());
            }
            case IP: {
                return String.format("%s", address.getIp().getHost());
            }
        }
        return null;
    }

    protected void printDropReasons() {
        if (this.dropReasons.isEmpty()) {
            return;
        }
        if (!log.isDebugEnabled()) {
            this.dropReasons.clear();
            return;
        }
        ((ConcurrentHashMap.KeySetView)this.dropReasons.keySet()).forEach(key -> {
            DropDataReason dropDataReason = this.dropReasons.remove(key);
            if (dropDataReason == null) {
                return;
            }
            long count = dropDataReason.count.get();
            switch (dropDataReason.type.ordinal()) {
                case 0: {
                    log.debug("Ignore the same service traffic, service name: {}, trigger count: {}", (Object)dropDataReason.service, (Object)count);
                    break;
                }
                case 1: {
                    log.debug("Ignore the connection loss, connection: {}, trigger count: {}", (Object)dropDataReason.connection, (Object)count);
                }
            }
        });
    }

    protected ProcessAddress buildProcessAddressByIP(NodeInfo nodeInfo, AccessLogConnection connection, boolean isLocal, IPAddress ipAddress) {
        ObjectID service;
        String host = ipAddress.getHost();
        if (!isLocal && connection.hasAttachment() && connection.getAttachment().hasZTunnel() && ZTunnelAttachmentEnvironmentDetectBy.ZTUNNEL_OUTBOUND_FUNC.equals((Object)connection.getAttachment().getZTunnel().getBy())) {
            ZTunnelAttachmentEnvironment ztunnel = connection.getAttachment().getZTunnel();
            host = ztunnel.getRealDestinationIp();
            log.debug("detected the ztunnel outbound connection, so update the remote IP address as: {}, detect by: {}", (Object)host, (Object)ztunnel.getBy());
        }
        if ((service = K8sInfoRegistry.getInstance().findServiceByIP(host)) != ObjectID.EMPTY) {
            return this.buildRemoteAddress(nodeInfo, service, null);
        }
        ObjectID pod = K8sInfoRegistry.getInstance().findPodByIP(host);
        if (pod == ObjectID.EMPTY) {
            log.debug("building unknown address by ip: {}:{}", (Object)host, (Object)ipAddress.getPort());
            return this.buildUnknownAddress();
        }
        ObjectID serviceName = K8sInfoRegistry.getInstance().findService(pod.namespace(), pod.name());
        if (serviceName == ObjectID.EMPTY) {
            log.debug("building unknown address by pod: {}:{}", (Object)pod.name(), (Object)ipAddress.getPort());
            return this.buildUnknownAddress();
        }
        return this.buildRemoteAddress(nodeInfo, serviceName, pod);
    }

    protected ProcessAddress buildUnknownAddress() {
        return UNKNOWN_ADDRESS;
    }

    protected ProcessAddress buildRemoteAddress(NodeInfo nodeInfo, ObjectID service, ObjectID pod) {
        String serviceName = service.name() + "." + service.namespace();
        if (StringUtil.isNotEmpty((String)nodeInfo.getClusterName())) {
            serviceName = nodeInfo.getClusterName() + "::" + serviceName;
        }
        return new K8sProcessAddress(KubernetesProcessAddress.newBuilder().setServiceName(serviceName).setPodName(pod == null ? "" : pod.name()).build());
    }

    protected List<Integer> buildConnectionComponentId(ConnectionInfo connectionInfo) {
        AccessLogConnection originalConnection = connectionInfo.getOriginalConnection();
        if (originalConnection.hasAttachment() && originalConnection.getAttachment().hasZTunnel()) {
            if (ZTunnelAttachmentSecurityPolicy.MTLS.equals((Object)originalConnection.getAttachment().getZTunnel().getSecurityPolicy())) {
                return Arrays.asList(142, 162);
            }
            return Arrays.asList(162);
        }
        return Arrays.asList(this.buildProtocolComponentID(connectionInfo));
    }

    protected int buildProtocolComponentID(ConnectionInfo connectionInfo) {
        boolean isTLS = connectionInfo.getTlsMode() == AccessLogConnectionTLSMode.TLS;
        switch (connectionInfo.getProtocolType()) {
            case HTTP_1: 
            case HTTP_2: {
                if (isTLS) {
                    return 129;
                }
                return 49;
            }
            case TCP: {
                if (isTLS) {
                    return 130;
                }
                return 110;
            }
        }
        return 0;
    }

    protected long convertNsToMs(long latency) {
        return TimeUnit.NANOSECONDS.toMillis(latency);
    }

    protected List<Service> buildBaseServiceFromRelation(K8SServiceRelation relation, Layer layer) {
        if (relation == null) {
            return Collections.emptyList();
        }
        Service localService = new Service();
        localService.setLayer(layer);
        localService.setName(relation.getSourceServiceName());
        localService.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)System.currentTimeMillis()));
        Service remoteService = new Service();
        remoteService.setLayer(layer);
        remoteService.setName(relation.getDestServiceName());
        remoteService.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)System.currentTimeMillis()));
        log.debug("generate the {} layer service local service: {}, remote service: {}", new Object[]{layer, relation.getSourceServiceName(), relation.getDestServiceName()});
        return Arrays.asList(localService, remoteService);
    }

    public class ConnectionInfo {
        private final AccessLogConnection originalConnection;
        private final NamingControl namingControl;
        private final ProcessAddress local;
        private final ProcessAddress remote;
        private final DetectPoint role;
        private final AccessLogConnectionTLSMode tlsMode;
        private final AccessLogProtocolType protocolType;
        private final NodeInfo nodeInfo;
        private final boolean valid;

        public ConnectionInfo(NamingControl namingControl, NodeInfo nodeInfo, AccessLogConnection connection) {
            this.originalConnection = connection;
            this.namingControl = namingControl;
            this.local = this.buildAddress(nodeInfo, connection, true, connection.getLocal());
            this.remote = this.buildAddress(nodeInfo, connection, false, connection.getRemote());
            this.role = connection.getRole();
            this.tlsMode = connection.getTlsMode();
            this.nodeInfo = nodeInfo;
            this.protocolType = connection.getProtocol();
            this.valid = this.generateIsValid();
            if (log.isDebugEnabled() && (Objects.equals(this.local, AccessLogServiceHandler.this.buildUnknownAddress()) || Objects.equals(this.remote, AccessLogServiceHandler.this.buildUnknownAddress()))) {
                log.debug("found unknown connection: {}", (Object)connection);
            }
        }

        private ProcessAddress buildAddress(NodeInfo nodeInfo, AccessLogConnection connection, boolean local, ConnectionAddress address) {
            switch (address.getAddressCase()) {
                case KUBERNETES: {
                    return new K8sProcessAddress(address.getKubernetes());
                }
                case IP: {
                    return AccessLogServiceHandler.this.buildProcessAddressByIP(nodeInfo, connection, local, address.getIp());
                }
            }
            return null;
        }

        private boolean generateIsValid() {
            if (this.local == null || this.remote == null || this.role == null || this.tlsMode == null || this.nodeInfo == null) {
                AccessLogServiceHandler.this.recordLessConnection(this.originalConnection);
                return false;
            }
            if (Objects.equals(this.local.getServiceName(), this.remote.getServiceName())) {
                AccessLogServiceHandler.this.recordIgnoreSameService(this.local.getServiceName());
                return false;
            }
            return true;
        }

        public String buildLocalServiceName() {
            return AccessLogServiceHandler.this.buildServiceNameByAddress(this.nodeInfo, this.local);
        }

        public K8SService toService() {
            if (Objects.equals(this.local, AccessLogServiceHandler.this.buildUnknownAddress())) {
                return null;
            }
            K8SService service = new K8SService();
            service.setName(AccessLogServiceHandler.this.buildServiceNameByAddress(this.nodeInfo, this.local));
            service.setLayer(Layer.K8S_SERVICE);
            service.setDetectPoint(this.parseToSourceRole());
            return service;
        }

        public K8SServiceInstance toServiceInstance() {
            if (Objects.equals(this.local, AccessLogServiceHandler.this.buildUnknownAddress()) || StringUtil.isEmpty((String)this.local.getInstanceName())) {
                return null;
            }
            K8SServiceInstance serviceInstance = new K8SServiceInstance();
            serviceInstance.setServiceName(AccessLogServiceHandler.this.buildServiceNameByAddress(this.nodeInfo, this.local));
            serviceInstance.setServiceInstanceName(AccessLogServiceHandler.this.buildServiceInstanceName(this.local));
            serviceInstance.setLayer(Layer.K8S_SERVICE);
            serviceInstance.setDetectPoint(this.parseToSourceRole());
            return serviceInstance;
        }

        public K8SServiceRelation toServiceRelation() {
            String destServiceName;
            Tuple2<ProcessAddress, ProcessAddress> tuple = this.convertSourceAndDestAddress();
            String sourceServiceName = AccessLogServiceHandler.this.buildServiceNameByAddress(this.nodeInfo, (ProcessAddress)tuple._1);
            if (Objects.equals(sourceServiceName, destServiceName = AccessLogServiceHandler.this.buildServiceNameByAddress(this.nodeInfo, (ProcessAddress)tuple._2))) {
                AccessLogServiceHandler.this.recordIgnoreSameService(sourceServiceName);
                return null;
            }
            K8SServiceRelation serviceRelation = new K8SServiceRelation();
            serviceRelation.setSourceServiceName(sourceServiceName);
            serviceRelation.setSourceLayer(Layer.K8S_SERVICE);
            serviceRelation.setDetectPoint(this.parseToSourceRole());
            serviceRelation.getComponentIds().addAll(AccessLogServiceHandler.this.buildConnectionComponentId(this));
            serviceRelation.setTlsMode(this.tlsMode);
            serviceRelation.setDestServiceName(destServiceName);
            serviceRelation.setDestLayer(Layer.K8S_SERVICE);
            return serviceRelation;
        }

        public K8SServiceInstanceRelation toServiceInstanceRelation() {
            if (StringUtil.isEmpty((String)this.local.getInstanceName()) || StringUtil.isEmpty((String)this.remote.getInstanceName())) {
                return null;
            }
            Tuple2<ProcessAddress, ProcessAddress> tuple = this.convertSourceAndDestAddress();
            K8SServiceInstanceRelation serviceInstanceRelation = new K8SServiceInstanceRelation();
            String sourceServiceName = AccessLogServiceHandler.this.buildServiceNameByAddress(this.nodeInfo, (ProcessAddress)tuple._1);
            String sourceServiceInstanceName = AccessLogServiceHandler.this.buildServiceInstanceName((ProcessAddress)tuple._1);
            String destServiceName = AccessLogServiceHandler.this.buildServiceNameByAddress(this.nodeInfo, (ProcessAddress)tuple._2);
            String destServiceInstanceName = AccessLogServiceHandler.this.buildServiceInstanceName((ProcessAddress)tuple._2);
            serviceInstanceRelation.setSourceServiceName(sourceServiceName);
            serviceInstanceRelation.setSourceServiceInstanceName(sourceServiceInstanceName);
            serviceInstanceRelation.setSourceLayer(Layer.K8S_SERVICE);
            serviceInstanceRelation.setDetectPoint(this.parseToSourceRole());
            serviceInstanceRelation.setDestServiceName(destServiceName);
            serviceInstanceRelation.setDestServiceInstanceName(destServiceInstanceName);
            serviceInstanceRelation.setDestLayer(Layer.K8S_SERVICE);
            return serviceInstanceRelation;
        }

        public Tuple2<ProcessAddress, ProcessAddress> convertSourceAndDestAddress() {
            ProcessAddress dest;
            ProcessAddress source;
            if (this.role == DetectPoint.server) {
                source = this.remote;
                dest = this.local;
            } else {
                source = this.local;
                dest = this.remote;
            }
            return new Tuple2((Object)source, (Object)dest);
        }

        public K8SEndpoint toEndpoint(String endpointName, boolean success, long duration) {
            if (this.role == DetectPoint.client) {
                return null;
            }
            K8SEndpoint endpoint = new K8SEndpoint();
            String serviceName = AccessLogServiceHandler.this.buildServiceNameByAddress(this.nodeInfo, this.local);
            endpoint.setServiceName(serviceName);
            endpoint.setEndpointName(this.namingControl.formatEndpointName(serviceName, endpointName));
            endpoint.setLayer(Layer.K8S_SERVICE);
            endpoint.setSuccess(success);
            endpoint.setDuration(duration);
            return endpoint;
        }

        public org.apache.skywalking.oap.server.core.source.DetectPoint parseToSourceRole() {
            switch (this.role) {
                case server: {
                    return org.apache.skywalking.oap.server.core.source.DetectPoint.SERVER;
                }
                case client: {
                    return org.apache.skywalking.oap.server.core.source.DetectPoint.CLIENT;
                }
                case proxy: {
                    return org.apache.skywalking.oap.server.core.source.DetectPoint.PROXY;
                }
            }
            return org.apache.skywalking.oap.server.core.source.DetectPoint.UNRECOGNIZED;
        }

        public AccessLogConnection getOriginal() {
            return this.originalConnection;
        }

        public String toString() {
            return String.format("local: %s, remote: %s, role: %s, tlsMode: %s, protocolType: %s, valid: %b", AccessLogServiceHandler.this.buildConnectionAddressString(this.originalConnection.getLocal()), AccessLogServiceHandler.this.buildConnectionAddressString(this.originalConnection.getRemote()), this.role, this.tlsMode, this.protocolType, this.isValid());
        }

        @Generated
        public AccessLogConnection getOriginalConnection() {
            return this.originalConnection;
        }

        @Generated
        public NamingControl getNamingControl() {
            return this.namingControl;
        }

        @Generated
        public ProcessAddress getLocal() {
            return this.local;
        }

        @Generated
        public ProcessAddress getRemote() {
            return this.remote;
        }

        @Generated
        public DetectPoint getRole() {
            return this.role;
        }

        @Generated
        public AccessLogConnectionTLSMode getTlsMode() {
            return this.tlsMode;
        }

        @Generated
        public AccessLogProtocolType getProtocolType() {
            return this.protocolType;
        }

        @Generated
        public NodeInfo getNodeInfo() {
            return this.nodeInfo;
        }

        @Generated
        public boolean isValid() {
            return this.valid;
        }
    }

    public static class NodeInfo {
        private final Map<Integer, String> netInterfaces;
        private final Instant bootTime;
        private final String clusterName;
        private final String nodeName;
        private final List<String> excludeNamespaces;

        public NodeInfo(EBPFAccessLogNodeInfo node) {
            this.nodeName = node.getName();
            this.netInterfaces = node.getNetInterfacesList().stream().collect(Collectors.toMap(EBPFAccessLogNodeNetInterface::getIndex, EBPFAccessLogNodeNetInterface::getName, (a, b) -> a));
            this.bootTime = node.getBootTime();
            this.clusterName = node.getClusterName();
            this.excludeNamespaces = this.buildExcludeNamespaces(node);
        }

        public String getNetInterfaceName(int index) {
            return this.netInterfaces.get(index);
        }

        public long parseMinuteTimeBucket(EBPFTimestamp timestamp) {
            long seconds = this.bootTime.getSeconds() + TimeUnit.NANOSECONDS.toSeconds(timestamp.getOffset().getOffset());
            return TimeBucket.getMinuteTimeBucket((long)(seconds * 1000L));
        }

        public long parseTimestamp(EBPFTimestamp timestamp) {
            return TimeUnit.SECONDS.toMillis(this.bootTime.getSeconds() + TimeUnit.NANOSECONDS.toSeconds(timestamp.getOffset().getOffset()));
        }

        public boolean shouldExcludeNamespace(String namespace) {
            return this.excludeNamespaces.contains(namespace);
        }

        public String toString() {
            return String.format("name: %s, clusterName: %s, network interfaces: %s", this.nodeName, this.clusterName, this.netInterfaces);
        }

        private List<String> buildExcludeNamespaces(EBPFAccessLogNodeInfo node) {
            if (node.hasPolicy() && node.getPolicy().getExcludeNamespacesCount() > 0) {
                return node.getPolicy().getExcludeNamespacesList().stream().filter(StringUtil::isNotEmpty).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        @Generated
        public String getClusterName() {
            return this.clusterName;
        }
    }

    private static class DropDataReason {
        private final DropReasonType type;
        private final String service;
        private final AccessLogConnection connection;
        private final AtomicLong count = new AtomicLong(0L);

        private DropDataReason(DropReasonType type, String service, AccessLogConnection connection) {
            this.type = type;
            this.service = service;
            this.connection = connection;
        }

        public static DropDataReason buildWhenSameService(String service) {
            return new DropDataReason(DropReasonType.SameService, service, null);
        }

        public static DropDataReason buildWhenConnectionLoss(AccessLogConnection connection) {
            return new DropDataReason(DropReasonType.ConnectionLoss, null, connection);
        }

        public void increaseCount() {
            this.count.incrementAndGet();
        }
    }

    private static enum DropReasonType {
        SameService,
        ConnectionLoss;

    }
}

