/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.AbstractContextAwareExecutorService;
import com.linecorp.armeria.common.ContextAwareEventLoop;
import com.linecorp.armeria.common.ContextAwareFuture;
import com.linecorp.armeria.common.ContextAwareProgressivePromise;
import com.linecorp.armeria.common.ContextAwarePromise;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ProgressivePromise;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

final class DefaultContextAwareEventLoop
extends AbstractContextAwareExecutorService<EventLoop>
implements ContextAwareEventLoop {
    private final RequestContext context;

    DefaultContextAwareEventLoop(RequestContext context, EventLoop eventLoop) {
        super(eventLoop);
        this.context = context;
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    @Nonnull
    public RequestContext contextOrNull() {
        return this.context;
    }

    public EventLoop next() {
        return this;
    }

    public EventLoopGroup parent() {
        return ((EventLoop)this.withoutContext()).parent();
    }

    public boolean inEventLoop() {
        return ((EventLoop)this.withoutContext()).inEventLoop();
    }

    public boolean inEventLoop(Thread thread) {
        return ((EventLoop)this.withoutContext()).inEventLoop(thread);
    }

    public <V> Promise<V> newPromise() {
        return new ContextAwarePromise(this.context, ((EventLoop)this.withoutContext()).newPromise());
    }

    public <V> ProgressivePromise<V> newProgressivePromise() {
        return new ContextAwareProgressivePromise(this.context, ((EventLoop)this.withoutContext()).newProgressivePromise());
    }

    public <V> Future<V> newSucceededFuture(V result) {
        return new ContextAwareFuture(this.context, ((EventLoop)this.withoutContext()).newSucceededFuture(result));
    }

    public <V> Future<V> newFailedFuture(Throwable cause) {
        return new ContextAwareFuture(this.context, ((EventLoop)this.withoutContext()).newFailedFuture(cause));
    }

    public boolean isShuttingDown() {
        return ((EventLoop)this.withoutContext()).isShuttingDown();
    }

    public Future<?> shutdownGracefully() {
        return ((EventLoop)this.withoutContext()).shutdownGracefully();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return ((EventLoop)this.withoutContext()).shutdownGracefully(quietPeriod, timeout, unit);
    }

    public Future<?> terminationFuture() {
        return ((EventLoop)this.withoutContext()).terminationFuture();
    }

    public Iterator<EventExecutor> iterator() {
        return ((EventLoop)this.withoutContext()).iterator();
    }

    @Override
    public Future<?> submit(Runnable task) {
        return (Future)super.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return (Future)super.submit(task, result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return (Future)super.submit(task);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return ((EventLoop)this.withoutContext()).schedule(this.context.makeContextAware(command), delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return ((EventLoop)this.withoutContext()).schedule(this.context.makeContextAware(callable), delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return ((EventLoop)this.withoutContext()).scheduleAtFixedRate(this.context.makeContextAware(command), initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return ((EventLoop)this.withoutContext()).scheduleWithFixedDelay(this.context.makeContextAware(command), initialDelay, delay, unit);
    }

    public ChannelFuture register(Channel channel) {
        return ((EventLoop)this.withoutContext()).register(channel);
    }

    public ChannelFuture register(ChannelPromise channelPromise) {
        return ((EventLoop)this.withoutContext()).register(channelPromise);
    }

    public ChannelFuture register(Channel channel, ChannelPromise channelPromise) {
        return ((EventLoop)this.withoutContext()).register(channel, channelPromise);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("context", this.context).add("eventLoop", this.withoutContext()).toString();
    }
}

