/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientTlsConfigBuilder;
import com.linecorp.armeria.common.AbstractTlsConfig;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.handler.ssl.SslContextBuilder;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

@UnstableApi
public final class ClientTlsConfig
extends AbstractTlsConfig {
    static final ClientTlsConfig NOOP = ClientTlsConfig.builder().build();
    private final boolean tlsNoVerifySet;
    private final Set<String> insecureHosts;

    public static ClientTlsConfigBuilder builder() {
        return new ClientTlsConfigBuilder();
    }

    ClientTlsConfig(boolean allowsUnsafeCiphers, @Nullable MeterIdPrefix meterIdPrefix, Consumer<SslContextBuilder> tlsCustomizer, boolean tlsNoVerifySet, Set<String> insecureHosts) {
        super(allowsUnsafeCiphers, meterIdPrefix, tlsCustomizer);
        this.tlsNoVerifySet = tlsNoVerifySet;
        this.insecureHosts = insecureHosts;
    }

    public boolean tlsNoVerifySet() {
        return this.tlsNoVerifySet;
    }

    public Set<String> insecureHosts() {
        return this.insecureHosts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientTlsConfig)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientTlsConfig that = (ClientTlsConfig)o;
        return this.tlsNoVerifySet == that.tlsNoVerifySet && this.insecureHosts.equals(that.insecureHosts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tlsNoVerifySet, this.insecureHosts);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("allowsUnsafeCiphers", this.allowsUnsafeCiphers()).add("meterIdPrefix", this.meterIdPrefix()).add("tlsCustomizer", this.tlsCustomizer()).add("tlsNoVerifySet", this.tlsNoVerifySet).add("insecureHosts", this.insecureHosts).toString();
    }
}

