/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.server.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;

public class PrivateKeyUtil {
    private static final String PKCS_1_PEM_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String PKCS_1_PEM_FOOTER = "-----END RSA PRIVATE KEY-----";
    private static final String PKCS_8_PEM_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static final String PKCS_8_PEM_FOOTER = "-----END PRIVATE KEY-----";

    public static InputStream loadDecryptionKey(String keyFilePath) throws IOException {
        byte[] keyDataBytes = Files.readAllBytes(Paths.get(keyFilePath, new String[0]));
        String keyDataString = new String(keyDataBytes, StandardCharsets.UTF_8);
        if (keyDataString.contains(PKCS_1_PEM_HEADER)) {
            keyDataString = keyDataString.replace(PKCS_1_PEM_HEADER, "");
            keyDataString = keyDataString.replace(PKCS_1_PEM_FOOTER, "");
            keyDataString = keyDataString.replace("\n", "");
            return PrivateKeyUtil.readPkcs1PrivateKey(Base64.getDecoder().decode(keyDataString));
        }
        return new ByteArrayInputStream(keyDataString.getBytes());
    }

    private static InputStream readPkcs1PrivateKey(byte[] pkcs1Bytes) {
        int pkcs1Length = pkcs1Bytes.length;
        int totalLength = pkcs1Length + 22;
        byte[] pkcs8Header = new byte[]{48, -126, (byte)(totalLength >> 8 & 0xFF), (byte)(totalLength & 0xFF), 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, (byte)(pkcs1Length >> 8 & 0xFF), (byte)(pkcs1Length & 0xFF)};
        StringBuilder pkcs8 = new StringBuilder(PKCS_8_PEM_HEADER);
        pkcs8.append("\n").append(new String(Base64.getEncoder().encode(PrivateKeyUtil.join(pkcs8Header, pkcs1Bytes)), StandardCharsets.UTF_8));
        pkcs8.append("\n").append(PKCS_8_PEM_FOOTER);
        return new ByteArrayInputStream(pkcs8.toString().getBytes());
    }

    private static byte[] join(byte[] byteArray1, byte[] byteArray2) {
        byte[] bytes = new byte[byteArray1.length + byteArray2.length];
        System.arraycopy(byteArray1, 0, bytes, 0, byteArray1.length);
        System.arraycopy(byteArray2, 0, bytes, byteArray1.length, byteArray2.length);
        return bytes;
    }
}

