/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTaskRecord;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBEBPFProfilingTaskDAO
extends AbstractBanyanDBDAO
implements IEBPFProfilingTaskDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"logical_id", (Object)"service_id", (Object)"instance_id", (Object)"process_labels_json", (Object)"trigger_type", (Object)"start_time", (Object[])new String[]{"fixed_trigger_duration", "target_type", "create_time", "last_update_time", "extension_config_json", "continuous_profiling_json"});

    public BanyanDBEBPFProfilingTaskDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<EBPFProfilingTaskRecord> queryTasksByServices(List<String> serviceIdList, final EBPFProfilingTriggerType triggerType, final long taskStartTime, final long latestUpdateTime) throws IOException {
        ArrayList<EBPFProfilingTaskRecord> tasks = new ArrayList<EBPFProfilingTaskRecord>();
        for (final String serviceId : serviceIdList) {
            StreamQueryResponse resp = this.query(false, "ebpf_profiling_task", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

                @Override
                protected void apply(StreamQuery query) {
                    query.and(this.eq("service_id", serviceId));
                    BanyanDBEBPFProfilingTaskDAO.this.appendTimeQuery(this, query, taskStartTime, latestUpdateTime);
                    if (triggerType != null) {
                        query.and(this.eq("trigger_type", triggerType.value()));
                    }
                    query.setOrderBy(new AbstractQuery.OrderBy(AbstractQuery.Sort.DESC));
                }
            });
            tasks.addAll(resp.getElements().stream().map(this::buildTask).collect(Collectors.toList()));
        }
        return tasks;
    }

    public List<EBPFProfilingTaskRecord> queryTasksByTargets(final String serviceId, final String serviceInstanceId, final List<EBPFProfilingTargetType> targetTypes, final EBPFProfilingTriggerType triggerType, final long taskStartTime, final long latestUpdateTime) throws IOException {
        ArrayList<EBPFProfilingTaskRecord> tasks = new ArrayList<EBPFProfilingTaskRecord>();
        for (final EBPFProfilingTargetType targetType : targetTypes) {
            StreamQueryResponse resp = this.query(false, "ebpf_profiling_task", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

                @Override
                protected void apply(StreamQuery query) {
                    if (StringUtil.isNotEmpty((String)serviceId)) {
                        query.and(this.eq("service_id", serviceId));
                    }
                    if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
                        query.and(this.eq("instance_id", serviceInstanceId));
                    }
                    if (CollectionUtils.isNotEmpty((List)targetTypes)) {
                        query.and(this.eq("trigger_type", triggerType.value()));
                    }
                    query.and(this.eq("target_type", targetType.value()));
                    BanyanDBEBPFProfilingTaskDAO.this.appendTimeQuery(this, query, taskStartTime, latestUpdateTime);
                    query.setOrderBy(new AbstractQuery.OrderBy(AbstractQuery.Sort.DESC));
                }
            });
            tasks.addAll(resp.getElements().stream().map(this::buildTask).collect(Collectors.toList()));
        }
        return tasks;
    }

    public List<EBPFProfilingTaskRecord> getTaskRecord(final String id) throws IOException {
        StreamQueryResponse resp = this.query(false, "ebpf_profiling_task", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                query.and(this.eq("logical_id", id));
            }
        });
        return resp.getElements().stream().map(this::buildTask).collect(Collectors.toList());
    }

    private void appendTimeQuery(AbstractBanyanDBDAO.QueryBuilder<StreamQuery> builder, StreamQuery query, long taskStartTime, long latestUpdateTime) {
        if (taskStartTime > 0L) {
            query.and(builder.gte("start_time", taskStartTime));
        }
        if (latestUpdateTime > 0L) {
            query.and(builder.gt("last_update_time", latestUpdateTime));
        }
    }

    private EBPFProfilingTaskRecord buildTask(RowEntity rowEntity) {
        EBPFProfilingTaskRecord.Builder builder = new EBPFProfilingTaskRecord.Builder();
        return builder.storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToStream("ebpf_profiling_task", rowEntity));
    }
}

