/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.skywalking.oap.server.core.storage.AbstractDAO;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.PrepareRequest;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.bulk.MeasureBulkWriteProcessor;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.bulk.StreamBulkWriteProcessor;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.bulk.TraceBulkWriteProcessor;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBMeasureInsertRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBMeasureUpdateRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBStreamInsertRequest;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.trace.BanyanDBTraceInsertRequest;

public class BanyanDBBatchDAO
extends AbstractDAO<BanyanDBStorageClient>
implements IBatchDAO {
    private static final Object STREAM_SYNCHRONIZER = new Object();
    private static final Object MEASURE_SYNCHRONIZER = new Object();
    private static final Object TRACE_SYNCHRONIZER = new Object();
    private StreamBulkWriteProcessor streamBulkWriteProcessor;
    private MeasureBulkWriteProcessor measureBulkWriteProcessor;
    private TraceBulkWriteProcessor traceBulkWriteProcessor;
    private final int maxBulkSize;
    private final int flushInterval;
    private final int concurrency;

    public BanyanDBBatchDAO(BanyanDBStorageClient client, int maxBulkSize, int flushInterval, int concurrency) {
        super((Client)client);
        this.maxBulkSize = maxBulkSize;
        this.flushInterval = flushInterval;
        this.concurrency = concurrency;
    }

    public void insert(InsertRequest insertRequest) {
        if (insertRequest instanceof BanyanDBStreamInsertRequest) {
            this.getStreamBulkWriteProcessor().add(((BanyanDBStreamInsertRequest)insertRequest).getStreamWrite());
        } else if (insertRequest instanceof BanyanDBMeasureInsertRequest) {
            this.getMeasureBulkWriteProcessor().add(((BanyanDBMeasureInsertRequest)insertRequest).getMeasureWrite());
        } else if (insertRequest instanceof BanyanDBTraceInsertRequest) {
            this.getTraceBulkWriteProcessor().add(((BanyanDBTraceInsertRequest)insertRequest).getTraceWrite());
        }
    }

    public CompletableFuture<Void> flush(List<PrepareRequest> prepareRequests) {
        if (CollectionUtils.isNotEmpty(prepareRequests)) {
            return CompletableFuture.allOf((CompletableFuture[])prepareRequests.stream().map(r -> {
                if (r instanceof BanyanDBStreamInsertRequest) {
                    return this.getStreamBulkWriteProcessor().add(((BanyanDBStreamInsertRequest)r).getStreamWrite());
                }
                if (r instanceof BanyanDBMeasureInsertRequest) {
                    return this.getMeasureBulkWriteProcessor().add(((BanyanDBMeasureInsertRequest)r).getMeasureWrite()).whenComplete((v, throwable) -> {
                        if (throwable == null) {
                            ((BanyanDBMeasureInsertRequest)r).onInsertCompleted();
                        }
                    });
                }
                if (r instanceof BanyanDBMeasureUpdateRequest) {
                    return this.getMeasureBulkWriteProcessor().add(((BanyanDBMeasureUpdateRequest)r).getMeasureWrite());
                }
                if (r instanceof BanyanDBTraceInsertRequest) {
                    return this.getTraceBulkWriteProcessor().add(((BanyanDBTraceInsertRequest)r).getTraceWrite());
                }
                return CompletableFuture.completedFuture(null);
            }).toArray(CompletableFuture[]::new));
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamBulkWriteProcessor getStreamBulkWriteProcessor() {
        if (this.streamBulkWriteProcessor == null) {
            Object object = STREAM_SYNCHRONIZER;
            synchronized (object) {
                if (this.streamBulkWriteProcessor == null) {
                    this.streamBulkWriteProcessor = ((BanyanDBStorageClient)this.getClient()).createStreamBulkProcessor(this.maxBulkSize, this.flushInterval, this.concurrency);
                }
            }
        }
        return this.streamBulkWriteProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MeasureBulkWriteProcessor getMeasureBulkWriteProcessor() {
        if (this.measureBulkWriteProcessor == null) {
            Object object = MEASURE_SYNCHRONIZER;
            synchronized (object) {
                if (this.measureBulkWriteProcessor == null) {
                    this.measureBulkWriteProcessor = ((BanyanDBStorageClient)this.getClient()).createMeasureBulkProcessor(this.maxBulkSize, this.flushInterval, this.concurrency);
                }
            }
        }
        return this.measureBulkWriteProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TraceBulkWriteProcessor getTraceBulkWriteProcessor() {
        if (this.traceBulkWriteProcessor == null) {
            Object object = TRACE_SYNCHRONIZER;
            synchronized (object) {
                if (this.traceBulkWriteProcessor == null) {
                    this.traceBulkWriteProcessor = ((BanyanDBStorageClient)this.getClient()).createTraceBulkProcessor(this.maxBulkSize, this.flushInterval, this.concurrency);
                }
            }
        }
        return this.traceBulkWriteProcessor;
    }
}

