/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.vservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanLayer;
import org.apache.skywalking.apm.network.language.agent.v3.SpanObject;
import org.apache.skywalking.oap.server.analyzer.provider.AnalyzerModuleConfig;
import org.apache.skywalking.oap.server.analyzer.provider.trace.DBLatencyThresholdsAndWatcher;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.vservice.VirtualServiceProcessor;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.DatabaseAccess;
import org.apache.skywalking.oap.server.core.source.DatabaseSlowStatement;
import org.apache.skywalking.oap.server.core.source.ServiceDatabaseSlowStatement;
import org.apache.skywalking.oap.server.core.source.ServiceMeta;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualDatabaseProcessor
implements VirtualServiceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VirtualDatabaseProcessor.class);
    private final NamingControl namingControl;
    private final AnalyzerModuleConfig config;
    private List<Source> recordList = new ArrayList<Source>();

    @Override
    public void prepareVSIfNecessary(SpanObject span, SegmentObject segmentObject) {
        if (span.getSpanLayer() != SpanLayer.Database) {
            return;
        }
        String peer = span.getPeer();
        long timeBucket = TimeBucket.getMinuteTimeBucket((long)span.getStartTime());
        String serviceName = this.namingControl.formatServiceName(peer);
        int latency = (int)(span.getEndTime() - span.getStartTime());
        this.recordList.add((Source)this.toServiceMeta(serviceName, timeBucket));
        this.recordList.add((Source)this.toDatabaseAccess(span, serviceName, timeBucket, latency));
        this.readStatementIfSlow(span.getTagsList(), latency).ifPresent(statement -> {
            this.recordList.add((Source)this.buildDatabaseSlowStatement(span, segmentObject, (String)statement, serviceName, latency));
            this.recordList.add((Source)this.buildServiceDatabaseSlowStatement(span, segmentObject, (String)statement, latency));
        });
    }

    private DatabaseSlowStatement buildDatabaseSlowStatement(SpanObject span, SegmentObject segmentObject, String statement, String serviceName, int latency) {
        DatabaseSlowStatement dbSlowStat = new DatabaseSlowStatement();
        dbSlowStat.setId(segmentObject.getTraceSegmentId() + "-" + span.getSpanId());
        dbSlowStat.setTraceId(segmentObject.getTraceId());
        dbSlowStat.setDatabaseServiceId(IDManager.ServiceID.buildId((String)serviceName, (boolean)false));
        dbSlowStat.setStatement(statement);
        dbSlowStat.setLatency((long)latency);
        dbSlowStat.setTimeBucket(TimeBucket.getRecordTimeBucket((long)span.getStartTime()));
        dbSlowStat.setTimestamp(span.getStartTime());
        return dbSlowStat;
    }

    private ServiceDatabaseSlowStatement buildServiceDatabaseSlowStatement(SpanObject span, SegmentObject segmentObject, String statement, int latency) {
        ServiceDatabaseSlowStatement serviceDbSlowStat = new ServiceDatabaseSlowStatement();
        serviceDbSlowStat.setId(segmentObject.getTraceSegmentId() + "-" + span.getSpanId());
        serviceDbSlowStat.setTraceId(segmentObject.getTraceId());
        serviceDbSlowStat.setServiceId(IDManager.ServiceID.buildId((String)segmentObject.getService(), (boolean)true));
        serviceDbSlowStat.setStatement(statement);
        serviceDbSlowStat.setLatency((long)latency);
        serviceDbSlowStat.setTimeBucket(TimeBucket.getRecordTimeBucket((long)span.getStartTime()));
        serviceDbSlowStat.setTimestamp(span.getStartTime());
        return serviceDbSlowStat;
    }

    private Optional<String> readStatementIfSlow(List<KeyStringValuePair> tags, int latency) {
        String statement = null;
        boolean isSlowDBAccess = false;
        for (KeyStringValuePair tag : tags) {
            if ("db.statement".equals(tag.getKey())) {
                statement = StringUtil.cut((String)tag.getValue(), (int)this.config.getMaxSlowSQLLength());
                continue;
            }
            if (!"db.type".equals(tag.getKey())) continue;
            String dbType = tag.getValue();
            DBLatencyThresholdsAndWatcher thresholds = this.config.getDbLatencyThresholdsAndWatcher();
            int threshold = thresholds.getThreshold(dbType);
            if (latency <= threshold) continue;
            isSlowDBAccess = true;
        }
        if (isSlowDBAccess) {
            return Optional.ofNullable(statement).filter(StringUtil::isNotBlank);
        }
        return Optional.empty();
    }

    private ServiceMeta toServiceMeta(String serviceName, Long timeBucket) {
        ServiceMeta service = new ServiceMeta();
        service.setName(serviceName);
        service.setLayer(Layer.VIRTUAL_DATABASE);
        service.setTimeBucket(timeBucket.longValue());
        return service;
    }

    private DatabaseAccess toDatabaseAccess(SpanObject span, String serviceName, long timeBucket, int latency) {
        DatabaseAccess databaseAccess = new DatabaseAccess();
        databaseAccess.setDatabaseTypeId(span.getComponentId());
        databaseAccess.setLatency(latency);
        databaseAccess.setName(serviceName);
        databaseAccess.setStatus(!span.getIsError());
        databaseAccess.setTimeBucket(timeBucket);
        return databaseAccess;
    }

    @Override
    public void emitTo(Consumer<Source> consumer) {
        this.recordList.forEach(consumer);
    }

    @Generated
    public VirtualDatabaseProcessor(NamingControl namingControl, AnalyzerModuleConfig config) {
        this.namingControl = namingControl;
        this.config = config;
    }
}

