/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.pprof.type;

import com.google.perftools.profiles.ProfileProto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.skywalking.oap.server.library.pprof.parser.PprofParser;
import org.apache.skywalking.oap.server.library.pprof.type.FrameTree;
import org.apache.skywalking.oap.server.library.pprof.type.RawFrameTree;

public class FrameTreeBuilder {
    private final ProfileProto.Profile profile;
    private final RawFrameTree root;

    public FrameTreeBuilder(ProfileProto.Profile profile) {
        this.profile = profile;
        this.root = new RawFrameTree(0L, 0L, 0L);
    }

    private FrameTree parseTree(RawFrameTree rawTree) {
        FrameTree tree = new FrameTree(this.getSignature(rawTree.getLocationId()), rawTree.getTotal(), rawTree.getSelf());
        for (RawFrameTree rawChild : rawTree.getChildren().values()) {
            FrameTree child = this.parseTree(rawChild);
            tree.getChildren().add(child);
        }
        return tree;
    }

    private String getSignature(long locationId) {
        return PprofParser.resolveSignature(locationId, this.profile);
    }

    public FrameTree build() {
        for (ProfileProto.Sample sample : this.profile.getSampleList()) {
            this.mergeSample(sample);
        }
        return this.parseTree(this.root);
    }

    private void mergeSample(ProfileProto.Sample sample) {
        Map<Long, RawFrameTree> children = this.root.getChildren();
        ArrayList<Long> locationIdList = new ArrayList<Long>(sample.getLocationIdList());
        Collections.reverse(locationIdList);
        int size = locationIdList.size();
        for (int i = 0; i < size; ++i) {
            RawFrameTree child;
            boolean isEnd = i == size - 1;
            long locationId = (Long)locationIdList.get(i);
            if (children.containsKey(locationId)) {
                child = children.get(locationId);
                child.setTotal(child.getTotal() + 1L);
                child.setSelf(child.getSelf() + (long)(isEnd ? 1 : 0));
                children = child.getChildren();
                continue;
            }
            child = new RawFrameTree(locationId, 1L, isEnd ? 1 : 0);
            children.put(locationId, child);
            children = child.getChildren();
        }
        this.root.setTotal(this.root.getTotal() + 1L);
    }
}

