/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.rt.parser;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oal.rt.parser.AggregationFuncStmt;
import org.apache.skywalking.oal.rt.parser.DataColumn;
import org.apache.skywalking.oal.rt.parser.EntryMethod;
import org.apache.skywalking.oal.rt.parser.FilterStmts;
import org.apache.skywalking.oal.rt.parser.FromStmt;
import org.apache.skywalking.oal.rt.parser.PersistenceColumns;
import org.apache.skywalking.oal.rt.parser.SourceColumn;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;

public class AnalysisResult {
    private String varName;
    private String metricsName;
    private String metricsClassPackage;
    private String tableName;
    private String sourcePackage;
    private String metricsClassName;
    private FromStmt from = new FromStmt();
    private FilterStmts filters = new FilterStmts();
    private AggregationFuncStmt aggregationFuncStmt = new AggregationFuncStmt();
    private EntryMethod entryMethod;
    private List<DataColumn> persistentFields;
    private List<SourceColumn> fieldsFromSource;
    private PersistenceColumns serializeFields;
    private String sourceDecorator;

    public void addPersistentField(String fieldName, String columnName, Class<?> type) {
        if (this.persistentFields == null) {
            this.persistentFields = new ArrayList<DataColumn>();
        }
        DataColumn dataColumn = new DataColumn(fieldName, columnName, type);
        this.persistentFields.add(dataColumn);
    }

    public void generateSerializeFields() {
        this.serializeFields = new PersistenceColumns();
        block12: for (SourceColumn sourceColumn : this.fieldsFromSource) {
            String type;
            switch (type = sourceColumn.getType().getSimpleName()) {
                case "int": {
                    this.serializeFields.addIntField(sourceColumn.getFieldName());
                    continue block12;
                }
                case "double": {
                    this.serializeFields.addDoubleField(sourceColumn.getFieldName());
                    continue block12;
                }
                case "String": {
                    this.serializeFields.addStringField(sourceColumn.getFieldName());
                    continue block12;
                }
                case "long": {
                    this.serializeFields.addLongField(sourceColumn.getFieldName());
                    continue block12;
                }
            }
            throw new IllegalStateException("Unexpected field type [" + type + "] of source sourceColumn [" + sourceColumn.getFieldName() + "]");
        }
        for (DataColumn column : this.persistentFields) {
            Class<?> columnType = column.getType();
            if (columnType.equals(Integer.TYPE)) {
                this.serializeFields.addIntField(column.getFieldName());
                continue;
            }
            if (columnType.equals(Double.TYPE)) {
                this.serializeFields.addDoubleField(column.getFieldName());
                continue;
            }
            if (columnType.equals(String.class)) {
                this.serializeFields.addStringField(column.getFieldName());
                continue;
            }
            if (columnType.equals(Long.TYPE)) {
                this.serializeFields.addLongField(column.getFieldName());
                continue;
            }
            if (StorageDataComplexObject.class.isAssignableFrom(columnType)) {
                this.serializeFields.addObjectField(column.getFieldName(), columnType.getName());
                continue;
            }
            throw new IllegalStateException("Unexpected field type [" + columnType.getSimpleName() + "] of persistence column [" + column.getFieldName() + "]");
        }
    }

    @Generated
    public String getVarName() {
        return this.varName;
    }

    @Generated
    public String getMetricsName() {
        return this.metricsName;
    }

    @Generated
    public String getMetricsClassPackage() {
        return this.metricsClassPackage;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getSourcePackage() {
        return this.sourcePackage;
    }

    @Generated
    public String getMetricsClassName() {
        return this.metricsClassName;
    }

    @Generated
    public FromStmt getFrom() {
        return this.from;
    }

    @Generated
    public FilterStmts getFilters() {
        return this.filters;
    }

    @Generated
    public AggregationFuncStmt getAggregationFuncStmt() {
        return this.aggregationFuncStmt;
    }

    @Generated
    public EntryMethod getEntryMethod() {
        return this.entryMethod;
    }

    @Generated
    public List<DataColumn> getPersistentFields() {
        return this.persistentFields;
    }

    @Generated
    public List<SourceColumn> getFieldsFromSource() {
        return this.fieldsFromSource;
    }

    @Generated
    public PersistenceColumns getSerializeFields() {
        return this.serializeFields;
    }

    @Generated
    public String getSourceDecorator() {
        return this.sourceDecorator;
    }

    @Generated
    public void setVarName(String varName) {
        this.varName = varName;
    }

    @Generated
    public void setMetricsName(String metricsName) {
        this.metricsName = metricsName;
    }

    @Generated
    public void setMetricsClassPackage(String metricsClassPackage) {
        this.metricsClassPackage = metricsClassPackage;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setSourcePackage(String sourcePackage) {
        this.sourcePackage = sourcePackage;
    }

    @Generated
    public void setMetricsClassName(String metricsClassName) {
        this.metricsClassName = metricsClassName;
    }

    @Generated
    public void setFrom(FromStmt from) {
        this.from = from;
    }

    @Generated
    public void setFilters(FilterStmts filters) {
        this.filters = filters;
    }

    @Generated
    public void setAggregationFuncStmt(AggregationFuncStmt aggregationFuncStmt) {
        this.aggregationFuncStmt = aggregationFuncStmt;
    }

    @Generated
    public void setEntryMethod(EntryMethod entryMethod) {
        this.entryMethod = entryMethod;
    }

    @Generated
    public void setPersistentFields(List<DataColumn> persistentFields) {
        this.persistentFields = persistentFields;
    }

    @Generated
    public void setFieldsFromSource(List<SourceColumn> fieldsFromSource) {
        this.fieldsFromSource = fieldsFromSource;
    }

    @Generated
    public void setSerializeFields(PersistenceColumns serializeFields) {
        this.serializeFields = serializeFields;
    }

    @Generated
    public void setSourceDecorator(String sourceDecorator) {
        this.sourceDecorator = sourceDecorator;
    }
}

