/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import com.google.protobuf.Descriptors;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.curioswitch.common.protobuf.json.ProtoFieldInfo;

final class CodeGenUtil {
    private static final Comparator<Descriptors.FieldDescriptor> FIELD_DESCRIPTOR_COMPARATOR = Comparator.comparing(Descriptors.FieldDescriptor::getNumber);

    static List<Descriptors.FieldDescriptor> sorted(List<Descriptors.FieldDescriptor> fields) {
        ArrayList<Descriptors.FieldDescriptor> sorted = new ArrayList<Descriptors.FieldDescriptor>(fields);
        sorted.sort(FIELD_DESCRIPTOR_COMPARATOR);
        return sorted;
    }

    static String fieldNameForNestedMarshaller(Descriptors.Descriptor descriptor) {
        return "MARSHALLER_" + descriptor.getFullName().replace('.', '_');
    }

    static String fieldNameForSerializedFieldName(ProtoFieldInfo field) {
        return "FIELD_NAME_" + field.descriptor().getNumber();
    }

    static StackManipulation invoke(Method method) {
        return MethodInvocation.invoke((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(method));
    }

    static Map<String, FieldDescription> fieldsByName(Implementation.Context implementationContext) {
        HashMap<String, FieldDescription> map = new HashMap<String, FieldDescription>();
        for (FieldDescription field : implementationContext.getInstrumentedType().getDeclaredFields()) {
            map.put(field.getName(), field);
        }
        return map;
    }

    static StackManipulation getEnumDescriptor(ProtoFieldInfo info) {
        MethodDescription.ForLoadedMethod getDescriptor;
        Class<?> clz = info.enumClass();
        try {
            getDescriptor = new MethodDescription.ForLoadedMethod(clz.getDeclaredMethod("getDescriptor", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Not an enum class: " + clz, e);
        }
        return MethodInvocation.invoke((MethodDescription.InDefinedShape)getDescriptor);
    }

    private CodeGenUtil() {
    }
}

