/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.url;

import graphql.Internal;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import java.util.function.Function;

@Internal
public final class UrlScalar {
    public static final GraphQLScalarType INSTANCE;

    private UrlScalar() {
    }

    private static Optional<URL> toURL(Object input) {
        if (input instanceof URL) {
            return Optional.of((URL)input);
        }
        if (input instanceof URI) {
            try {
                return Optional.of(((URI)input).toURL());
            }
            catch (MalformedURLException malformedURLException) {
            }
        } else if (input instanceof File) {
            try {
                return Optional.of(((File)input).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    static {
        Coercing<URL, URL> coercing = new Coercing<URL, URL>(){

            public URL serialize(Object input) throws CoercingSerializeException {
                Optional<URL> url = input instanceof String ? Optional.of(this.parseURL(input.toString(), CoercingSerializeException::new)) : UrlScalar.toURL(input);
                if (url.isPresent()) {
                    return url.get();
                }
                throw new CoercingSerializeException("Expected a 'URL' like object but was '" + Kit.typeName(input) + "'.");
            }

            public URL parseValue(Object input) throws CoercingParseValueException {
                if (!(input instanceof String)) {
                    Optional url = UrlScalar.toURL(input);
                    if (!url.isPresent()) {
                        throw new CoercingParseValueException("Expected a 'URL' like object but was '" + Kit.typeName(input) + "'.");
                    }
                    return (URL)url.get();
                }
                String urlStr = String.valueOf(input);
                return this.parseURL(urlStr, CoercingParseValueException::new);
            }

            public URL parseLiteral(Object input) throws CoercingParseLiteralException {
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + Kit.typeName(input) + "'.");
                }
                return this.parseURL(((StringValue)input).getValue(), CoercingParseLiteralException::new);
            }

            public Value valueToLiteral(Object input) {
                URL url = this.serialize(input);
                return StringValue.newStringValue((String)url.toExternalForm()).build();
            }

            private URL parseURL(String input, Function<String, RuntimeException> exceptionMaker) {
                try {
                    return new URL(input);
                }
                catch (MalformedURLException e) {
                    throw exceptionMaker.apply("Invalid URL value : '" + input + "'.");
                }
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("Url").description("A Url scalar").coercing((Coercing)coercing).build();
    }
}

