/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.search.aggregation;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.Aggregation;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.BucketOrder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.TermsAggregationBuilder;

@JsonSerialize(using=Serializer.class)
public final class TermsAggregation
extends Aggregation {
    private final String name;
    private final String field;
    private final BucketOrder order;
    private final Integer size;
    private final ImmutableMap<String, Aggregation> aggregations;
    private final TermsAggregationBuilder.CollectMode collectMode;
    private final TermsAggregationBuilder.ExecutionHint executionHint;

    @Override
    public String name() {
        return this.name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getField() {
        return this.field;
    }

    @Generated
    public BucketOrder getOrder() {
        return this.order;
    }

    @Generated
    public Integer getSize() {
        return this.size;
    }

    @Generated
    public ImmutableMap<String, Aggregation> getAggregations() {
        return this.aggregations;
    }

    @Generated
    public TermsAggregationBuilder.CollectMode getCollectMode() {
        return this.collectMode;
    }

    @Generated
    public TermsAggregationBuilder.ExecutionHint getExecutionHint() {
        return this.executionHint;
    }

    @Generated
    TermsAggregation(String name, String field, BucketOrder order, Integer size, ImmutableMap<String, Aggregation> aggregations, TermsAggregationBuilder.CollectMode collectMode, TermsAggregationBuilder.ExecutionHint executionHint) {
        this.name = name;
        this.field = field;
        this.order = order;
        this.size = size;
        this.aggregations = aggregations;
        this.collectMode = collectMode;
        this.executionHint = executionHint;
    }

    static final class Serializer
    extends JsonSerializer<TermsAggregation> {
        Serializer() {
        }

        public void serialize(TermsAggregation value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("terms");
            gen.writeStartObject();
            gen.writeStringField("field", value.getField());
            if (value.getSize() != null) {
                gen.writeNumberField("size", value.getSize().intValue());
            }
            if (value.getOrder() != null) {
                this.writeOrder(value, gen);
            }
            if (value.getCollectMode() != null) {
                gen.writeStringField("collect_mode", value.getCollectMode().value);
            }
            if (value.getExecutionHint() != null) {
                gen.writeStringField("execution_hint", value.getExecutionHint().value);
            }
            gen.writeEndObject();
            if (value.getAggregations() != null && !value.getAggregations().isEmpty()) {
                gen.writeObjectField("aggregations", value.getAggregations());
            }
            gen.writeEndObject();
        }

        private void writeOrder(TermsAggregation value, JsonGenerator gen) throws IOException {
            gen.writeFieldName("order");
            gen.writeStartObject();
            gen.writeStringField(value.getOrder().getPath(), value.getOrder().isAsc() ? "asc" : "desc");
            gen.writeEndObject();
        }
    }
}

