/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.factory.v7plus.codec;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.response.IndexTemplate;
import org.apache.skywalking.library.elasticsearch.response.IndexTemplates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class V78IndexTemplatesDeserializer
extends JsonDeserializer<IndexTemplates> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V78IndexTemplatesDeserializer.class);
    private static final TypeReference<List<IndexTemplateWrapper>> TYPE_REFERENCE = new TypeReference<List<IndexTemplateWrapper>>(){};

    V78IndexTemplatesDeserializer() {
    }

    public IndexTemplates deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        while (!p.nextFieldName((SerializableString)new SerializedString("index_templates"))) {
            if (p.currentName() == null) {
                return new IndexTemplates(Collections.emptyMap());
            }
            p.skipChildren();
        }
        if (p.nextToken() != JsonToken.START_ARRAY) {
            throw new UnsupportedOperationException("this might be a new ElasticSearch version and we don't support yet");
        }
        JsonNode array = (JsonNode)p.getCodec().readTree(p);
        ArrayList<IndexTemplate> templates = new ArrayList<IndexTemplate>(array.size());
        for (JsonNode node : array) {
            String name = node.get("name").asText();
            if (Strings.isNullOrEmpty((String)name)) {
                log.error("index template without a name: {}", (Object)node);
                continue;
            }
            JsonNode indexTemplateNode = node.get("index_template");
            if (indexTemplateNode == null) {
                log.error("index template without index_template: {}", (Object)node);
                continue;
            }
            IndexTemplateWrapper wrapper = (IndexTemplateWrapper)p.getCodec().treeToValue((TreeNode)indexTemplateNode, IndexTemplateWrapper.class);
            wrapper.getTemplate().setName(name);
            wrapper.getTemplate().setIndexPatterns(wrapper.getIndexPatterns());
            templates.add(wrapper.getTemplate());
        }
        Map<String, IndexTemplate> templateMap = templates.stream().collect(Collectors.toMap(IndexTemplate::getName, Function.identity()));
        return new IndexTemplates(templateMap);
    }

    static final class IndexTemplateWrapper {
        @JsonProperty(value="index_patterns")
        private List<String> indexPatterns;
        private IndexTemplate template;

        @Generated
        public IndexTemplateWrapper() {
        }

        @Generated
        public List<String> getIndexPatterns() {
            return this.indexPatterns;
        }

        @Generated
        public IndexTemplate getTemplate() {
            return this.template;
        }

        @JsonProperty(value="index_patterns")
        @Generated
        public void setIndexPatterns(List<String> indexPatterns) {
            this.indexPatterns = indexPatterns;
        }

        @Generated
        public void setTemplate(IndexTemplate template) {
            this.template = template;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexTemplateWrapper)) {
                return false;
            }
            IndexTemplateWrapper other = (IndexTemplateWrapper)o;
            List<String> this$indexPatterns = this.getIndexPatterns();
            List<String> other$indexPatterns = other.getIndexPatterns();
            if (this$indexPatterns == null ? other$indexPatterns != null : !((Object)this$indexPatterns).equals(other$indexPatterns)) {
                return false;
            }
            IndexTemplate this$template = this.getTemplate();
            IndexTemplate other$template = other.getTemplate();
            return !(this$template == null ? other$template != null : !((Object)this$template).equals(other$template));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $indexPatterns = this.getIndexPatterns();
            result = result * 59 + ($indexPatterns == null ? 43 : ((Object)$indexPatterns).hashCode());
            IndexTemplate $template = this.getTemplate();
            result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "V78IndexTemplatesDeserializer.IndexTemplateWrapper(indexPatterns=" + String.valueOf(this.getIndexPatterns()) + ", template=" + String.valueOf(this.getTemplate()) + ")";
        }
    }
}

