/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.catalog.ServiceWeights;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="ServiceWeights", generator="Immutables")
@Immutable
public final class ImmutableServiceWeights
extends ServiceWeights {
    private final int passing;
    private final int warning;

    private ImmutableServiceWeights(int passing, int warning) {
        this.passing = passing;
        this.warning = warning;
    }

    @Override
    @JsonProperty(value="Passing")
    public int getPassing() {
        return this.passing;
    }

    @Override
    @JsonProperty(value="Warning")
    public int getWarning() {
        return this.warning;
    }

    public final ImmutableServiceWeights withPassing(int value) {
        if (this.passing == value) {
            return this;
        }
        return new ImmutableServiceWeights(value, this.warning);
    }

    public final ImmutableServiceWeights withWarning(int value) {
        if (this.warning == value) {
            return this;
        }
        return new ImmutableServiceWeights(this.passing, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceWeights && this.equalTo((ImmutableServiceWeights)another);
    }

    private boolean equalTo(ImmutableServiceWeights another) {
        return this.passing == another.passing && this.warning == another.warning;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.passing;
        h += (h << 5) + this.warning;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServiceWeights").omitNullValues().add("passing", this.passing).add("warning", this.warning).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServiceWeights fromJson(Json json) {
        Builder builder = ImmutableServiceWeights.builder();
        if (json.passingIsSet) {
            builder.passing(json.passing);
        }
        if (json.warningIsSet) {
            builder.warning(json.warning);
        }
        return builder.build();
    }

    public static ImmutableServiceWeights copyOf(ServiceWeights instance) {
        if (instance instanceof ImmutableServiceWeights) {
            return (ImmutableServiceWeights)instance;
        }
        return ImmutableServiceWeights.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServiceWeights", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PASSING = 1L;
        private static final long INIT_BIT_WARNING = 2L;
        private long initBits = 3L;
        private int passing;
        private int warning;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServiceWeights instance) {
            Objects.requireNonNull(instance, "instance");
            this.passing(instance.getPassing());
            this.warning(instance.getWarning());
            return this;
        }

        @JsonProperty(value="Passing")
        @CanIgnoreReturnValue
        public final Builder passing(int passing) {
            this.passing = passing;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Warning")
        @CanIgnoreReturnValue
        public final Builder warning(int warning) {
            this.warning = warning;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableServiceWeights build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceWeights(this.passing, this.warning);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("passing");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("warning");
            }
            return "Cannot build ServiceWeights, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ServiceWeights", generator="Immutables")
    static final class Json
    extends ServiceWeights {
        int passing;
        boolean passingIsSet;
        int warning;
        boolean warningIsSet;

        Json() {
        }

        @JsonProperty(value="Passing")
        public void setPassing(int passing) {
            this.passing = passing;
            this.passingIsSet = true;
        }

        @JsonProperty(value="Warning")
        public void setWarning(int warning) {
            this.warning = warning;
            this.warningIsSet = true;
        }

        @Override
        public int getPassing() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getWarning() {
            throw new UnsupportedOperationException();
        }
    }
}

