/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.grpc.protocol.GrpcWebTrailers;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.internal.common.metric.DefaultMeterIdPrefixFunction;
import com.linecorp.armeria.internal.common.util.StringUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.grpc.Status;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class GrpcMeterIdPrefixFunction
implements MeterIdPrefixFunction {
    private static final Map<String, Tag> STATUS_TAGS = (Map)Arrays.stream(Status.Code.values()).map(code -> StringUtil.toString((int)code.value())).collect(ImmutableMap.toImmutableMap(Function.identity(), code -> Tag.of((String)"grpc.status", (String)code)));
    private static final Tag OK_TAG = Tag.of((String)"grpc.status", (String)StringUtil.toString((int)0));
    private static final Tag UNKNOWN_TAG = Tag.of((String)"grpc.status", (String)StringUtil.toString((int)2));
    private final String name;

    public static GrpcMeterIdPrefixFunction of(String name) {
        return new GrpcMeterIdPrefixFunction(name);
    }

    private GrpcMeterIdPrefixFunction(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    public MeterIdPrefix activeRequestPrefix(MeterRegistry registry, RequestOnlyLog log) {
        ImmutableList.Builder tagListBuilder = ImmutableList.builderWithExpectedSize((int)3);
        DefaultMeterIdPrefixFunction.addActiveRequestPrefixTags((ImmutableList.Builder)tagListBuilder, (RequestOnlyLog)log);
        return new MeterIdPrefix(this.name, (Iterable)tagListBuilder.build());
    }

    public MeterIdPrefix completeRequestPrefix(MeterRegistry registry, RequestLog log) {
        ImmutableList.Builder tagListBuilder = ImmutableList.builderWithExpectedSize((int)4);
        GrpcMeterIdPrefixFunction.addGrpcStatus((ImmutableList.Builder<Tag>)tagListBuilder, log);
        DefaultMeterIdPrefixFunction.addCompleteRequestPrefixTags((ImmutableList.Builder)tagListBuilder, (RequestLog)log);
        return new MeterIdPrefix(this.name, (Iterable)tagListBuilder.build());
    }

    private static void addGrpcStatus(ImmutableList.Builder<Tag> tagListBuilder, RequestLog log) {
        String status = log.responseHeaders().get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
        if (status != null) {
            tagListBuilder.add((Object)GrpcMeterIdPrefixFunction.statusTag(status));
            return;
        }
        status = log.responseTrailers().get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
        if (status != null) {
            tagListBuilder.add((Object)GrpcMeterIdPrefixFunction.statusTag(status));
            return;
        }
        HttpHeaders trailers = GrpcWebTrailers.get((RequestContext)log.context());
        if (trailers != null && (status = trailers.get((CharSequence)GrpcHeaderNames.GRPC_STATUS)) != null) {
            tagListBuilder.add((Object)GrpcMeterIdPrefixFunction.statusTag(status));
            return;
        }
        tagListBuilder.add((Object)UNKNOWN_TAG);
    }

    private static Tag statusTag(String status) {
        if ("0".equals(status)) {
            return OK_TAG;
        }
        Tag cached = STATUS_TAGS.get(status);
        if (cached != null) {
            return cached;
        }
        return Tag.of((String)"grpc.status", (String)status);
    }
}

