/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

public enum IterationStrategy {
    ASCENDING(false),
    DESCENDING(false),
    BUFFER_SOURCE(true),
    BUFFER_TARGET(true);

    final boolean needBuffer;

    private IterationStrategy(boolean needBuffer) {
        this.needBuffer = needBuffer;
    }

    public static IterationStrategy suggest(int srcOff, int srcDim, int dstOff, int dstDim, int numPts) {
        int d;
        if (numPts <= 1) {
            return ASCENDING;
        }
        int delta = Math.subtractExact(srcOff, dstOff);
        if (delta >= 0) {
            d = srcDim - dstDim;
            if (d >= 0 || delta >= Math.multiplyExact(1 - numPts, d)) {
                return ASCENDING;
            }
        } else {
            if ((delta = Math.negateExact(delta)) >= Math.multiplyExact(numPts, srcDim)) {
                return ASCENDING;
            }
            d = srcDim - dstDim;
            if (delta >= Math.multiplyExact(numPts - 1, d)) {
                return DESCENDING;
            }
        }
        return d > 0 ? BUFFER_TARGET : BUFFER_SOURCE;
    }
}

