/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.util;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConcurrentMapConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;

public class ConfigurationUtils {
    public static ConcurrentCompositeConfiguration convertToConcurrentCompositeConfiguration(CombinedConfiguration combinedConfiguration) {
        Object object;
        ConcurrentCompositeConfiguration concurrentCompositeConfiguration = new ConcurrentCompositeConfiguration();
        IdentityHashMap<Configuration, String> identityHashMap = new IdentityHashMap<Configuration, String>();
        for (String string : combinedConfiguration.getConfigurationNames()) {
            object = combinedConfiguration.getConfiguration(string);
            identityHashMap.put((Configuration)object, string);
        }
        for (int i = 0; i < combinedConfiguration.getNumberOfConfigurations(); ++i) {
            Object object2;
            String string;
            string = combinedConfiguration.getConfiguration(i);
            object = (String)identityHashMap.get(string);
            if (string instanceof CombinedConfiguration) {
                object2 = (CombinedConfiguration)string;
                ConcurrentCompositeConfiguration concurrentCompositeConfiguration2 = ConfigurationUtils.convertToConcurrentCompositeConfiguration(object2);
                concurrentCompositeConfiguration.addConfiguration(concurrentCompositeConfiguration2, (String)object);
                continue;
            }
            object2 = new ConcurrentMapConfiguration((Configuration)string);
            concurrentCompositeConfiguration.addConfiguration((AbstractConfiguration)object2, (String)object);
        }
        return concurrentCompositeConfiguration;
    }

    public static Map<String, Configuration> getAllNamedConfiguration(Configuration configuration) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<String, Configuration> hashMap = new HashMap<String, Configuration>();
        arrayList.add(configuration);
        while (!arrayList.isEmpty()) {
            ConcurrentCompositeConfiguration concurrentCompositeConfiguration;
            Configuration configuration2 = (Configuration)arrayList.remove(0);
            if (configuration2 instanceof ConcurrentCompositeConfiguration) {
                concurrentCompositeConfiguration = (ConcurrentCompositeConfiguration)configuration2;
                for (String string : concurrentCompositeConfiguration.getConfigurationNames()) {
                    hashMap.put(string, concurrentCompositeConfiguration.getConfiguration(string));
                }
                for (AbstractConfiguration abstractConfiguration : concurrentCompositeConfiguration.getConfigurations()) {
                    arrayList.add(abstractConfiguration);
                }
                continue;
            }
            if (!(configuration2 instanceof CombinedConfiguration)) continue;
            concurrentCompositeConfiguration = (CombinedConfiguration)configuration2;
            for (String string : concurrentCompositeConfiguration.getConfigurationNames()) {
                hashMap.put(string, concurrentCompositeConfiguration.getConfiguration(string));
            }
            for (int i = 0; i < concurrentCompositeConfiguration.getNumberOfConfigurations(); ++i) {
                arrayList.add(concurrentCompositeConfiguration.getConfiguration(i));
            }
        }
        return hashMap;
    }

    public static Properties getProperties(AbstractConfiguration abstractConfiguration) {
        Properties properties = new Properties();
        if (abstractConfiguration != null) {
            Iterator iterator = abstractConfiguration.getKeys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                properties.put(string, abstractConfiguration.getString(string));
            }
        }
        return properties;
    }

    public static void loadProperties(Properties properties, Configuration configuration) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            configuration.setProperty((String)entry.getKey(), entry.getValue());
        }
    }
}

