/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.httpclient;

import java.net.URI;
import java.util.Map;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.ResultEnum;
import org.apache.shenyu.common.enums.UniqueHeaderEnum;
import org.apache.shenyu.plugin.base.utils.MediaTypeUtils;
import org.apache.shenyu.plugin.httpclient.AbstractHttpClientPlugin;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebClientPlugin
extends AbstractHttpClientPlugin<ResponseEntity<Flux<DataBuffer>>> {
    private final WebClient webClient;

    public WebClientPlugin(WebClient webClient) {
        this.webClient = webClient;
    }

    @Override
    protected Mono<ResponseEntity<Flux<DataBuffer>>> doRequest(ServerWebExchange exchange, String httpMethod, URI uri, Flux<DataBuffer> body) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders httpHeaders = new HttpHeaders((MultiValueMap)request.getHeaders());
        this.duplicateHeaders(exchange, httpHeaders, UniqueHeaderEnum.REQ_UNIQUE_HEADER);
        WebClient.ResponseSpec responseSpec = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(HttpMethod.valueOf((String)httpMethod)).uri(uri)).headers(headers -> {
            headers.addAll((MultiValueMap)exchange.getRequest().getHeaders());
            headers.remove((Object)"Host");
            Boolean preserveHost = (Boolean)exchange.getAttributeOrDefault("preserveHost", (Object)Boolean.FALSE);
            if (preserveHost.booleanValue()) {
                headers.add("Host", request.getHeaders().getFirst("Host"));
            }
        })).body((outputMessage, context) -> {
            MediaType mediaType = exchange.getRequest().getHeaders().getContentType();
            if (MediaTypeUtils.isByteType((MediaType)mediaType)) {
                return outputMessage.writeWith((Publisher)body);
            }
            return outputMessage.writeWith((Publisher)DataBufferUtils.join((Publisher)body));
        }).retrieve().onRawStatus(httpStatus -> httpStatus >= 400, clientResponse -> Mono.empty());
        return responseSpec.toEntityFlux(DataBuffer.class).flatMap(fluxResponseEntity -> {
            if (fluxResponseEntity.getStatusCode().is2xxSuccessful()) {
                exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
            } else {
                exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.ERROR.getName());
            }
            HttpHeaders headers = new HttpHeaders();
            headers.addAll((MultiValueMap)fluxResponseEntity.getHeaders());
            this.duplicateHeaders(exchange, headers, UniqueHeaderEnum.RESP_UNIQUE_HEADER);
            exchange.getResponse().getHeaders().putAll((Map)headers);
            exchange.getResponse().setStatusCode(fluxResponseEntity.getStatusCode());
            exchange.getAttributes().put("webHandlerClientResponse", fluxResponseEntity);
            return Mono.just((Object)fluxResponseEntity);
        });
    }

    public int getOrder() {
        return PluginEnum.WEB_CLIENT.getCode();
    }

    public String named() {
        return PluginEnum.WEB_CLIENT.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExceptHttpLike(exchange);
    }
}

