/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.proxy.enhanced.handler;

import java.util.Objects;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.AiProxyHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.ai.proxy.enhanced.cache.ChatClientCache;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;

public class AiProxyPluginHandler
implements PluginDataHandler {
    private final CommonHandleCache<String, AiProxyHandle> selectorCachedHandle = new CommonHandleCache();
    private final ChatClientCache chatClientCache;

    public AiProxyPluginHandler(ChatClientCache chatClientCache) {
        this.chatClientCache = chatClientCache;
    }

    public void handlerPlugin(PluginData pluginData) {
    }

    public void handlerSelector(SelectorData selectorData) {
        this.chatClientCache.remove(selectorData.getId());
        if (Objects.isNull(selectorData.getHandle())) {
            return;
        }
        AiProxyHandle aiProxyHandle = (AiProxyHandle)GsonUtils.getInstance().fromJson(selectorData.getHandle(), AiProxyHandle.class);
        aiProxyHandle.normalize();
        this.selectorCachedHandle.cachedHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"), (Object)aiProxyHandle);
    }

    public void removeSelector(SelectorData selectorData) {
        this.chatClientCache.remove(selectorData.getId());
        this.selectorCachedHandle.removeHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"));
    }

    public String pluginNamed() {
        return PluginEnum.AI_PROXY.getName();
    }

    public CommonHandleCache<String, AiProxyHandle> getSelectorCachedHandle() {
        return this.selectorCachedHandle;
    }
}

