/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.general.context.handler;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.rule.GeneralContextHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;

public class GeneralContextPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, Map<String, List<GeneralContextHandle>>>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(handleData -> {
            Map generalContextHandleMap = GsonUtils.getInstance().toObjectMapList(handleData, GeneralContextHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)generalContextHandleMap);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }

    public String pluginNamed() {
        return PluginEnum.GENERAL_CONTEXT.getName();
    }
}

