/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.reactor;

import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public final class ReactorSphU {
    public static <R> Mono<R> entryWith(String resourceName, Mono<R> actual) {
        return ReactorSphU.entryWith(resourceName, EntryType.OUT, actual);
    }

    public static <R> Mono<R> entryWith(String resourceName, EntryType entryType, Mono<R> actual) {
        AtomicReference<Object> entryWrapper = new AtomicReference<Object>(null);
        return Mono.defer(() -> {
            try {
                AsyncEntry entry = SphU.asyncEntry((String)resourceName, (EntryType)entryType);
                entryWrapper.set(entry);
                return actual.subscriberContext(context -> {
                    if (entry == null) {
                        return context;
                    }
                    Context sentinelContext = entry.getAsyncContext();
                    if (sentinelContext == null) {
                        return context;
                    }
                    return context.put((Object)"_sentinel_context", (Object)sentinelContext);
                }).doOnSuccessOrError((o, t) -> {
                    if (entry != null && entryWrapper.compareAndSet(entry, null)) {
                        if (t != null) {
                            Tracer.traceContext((Throwable)t, (int)1, (Context)entry.getAsyncContext());
                        }
                        entry.exit();
                    }
                });
            }
            catch (BlockException ex) {
                return Mono.error((Throwable)ex);
            }
        });
    }

    private ReactorSphU() {
    }
}

