/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config.springsupport;

import com.weibo.api.motan.config.BasicServiceInterfaceConfig;
import com.weibo.api.motan.config.ConfigUtil;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.config.springsupport.MotanNamespaceHandler;
import com.weibo.api.motan.config.springsupport.util.SpringBeanUtil;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public class BasicServiceConfigBean
extends BasicServiceInterfaceConfig
implements BeanNameAware,
InitializingBean,
BeanFactoryAware {
    private String registryNames;
    BeanFactory beanFactory;

    public void setBeanName(String name) {
        this.setId(name);
        MotanNamespaceHandler.basicServiceConfigDefineNames.add(name);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        String protocol = ConfigUtil.extractProtocols((String)this.getExport());
        this.setRegistries(this.extractRegistries(this.registryNames, this.beanFactory));
        this.setProtocols(this.extractProtocols(protocol, this.beanFactory));
    }

    public List<ProtocolConfig> extractProtocols(String protocols, BeanFactory beanFactory) {
        if (protocols != null && protocols.length() > 0) {
            List<ProtocolConfig> protocolConfigList = SpringBeanUtil.getMultiBeans(beanFactory, protocols, "\\s*[,]+\\s*", ProtocolConfig.class);
            return protocolConfigList;
        }
        return null;
    }

    public List<RegistryConfig> extractRegistries(String registries, BeanFactory beanFactory) {
        if (registries != null && registries.length() > 0) {
            if (!registries.contains(",")) {
                RegistryConfig registryConfig = (RegistryConfig)beanFactory.getBean(registries, RegistryConfig.class);
                return Collections.singletonList(registryConfig);
            }
            List<RegistryConfig> registryConfigList = SpringBeanUtil.getMultiBeans(beanFactory, registries, "\\s*[,]+\\s*", RegistryConfig.class);
            return registryConfigList;
        }
        return null;
    }

    public void setRegistry(String registryNames) {
        this.registryNames = registryNames;
    }

    public void setCheck(boolean value) {
        this.setCheck(String.valueOf(value));
    }

    public void setAccessLog(boolean value) {
        this.setAccessLog(String.valueOf(value));
    }
}

