/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.SlowlogTresholds;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SlowlogSettings
implements JsonpSerializable {
    @Nullable
    private final String level;
    @Nullable
    private final Integer source;
    @Nullable
    private final Boolean reformat;
    @Nullable
    private final SlowlogTresholds threshold;
    public static final JsonpDeserializer<SlowlogSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlowlogSettings::setupSlowlogSettingsDeserializer);

    private SlowlogSettings(Builder builder) {
        this.level = builder.level;
        this.source = builder.source;
        this.reformat = builder.reformat;
        this.threshold = builder.threshold;
    }

    public static SlowlogSettings of(Function<Builder, ObjectBuilder<SlowlogSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String level() {
        return this.level;
    }

    @Nullable
    public final Integer source() {
        return this.source;
    }

    @Nullable
    public final Boolean reformat() {
        return this.reformat;
    }

    @Nullable
    public final SlowlogTresholds threshold() {
        return this.threshold;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.level != null) {
            generator.writeKey("level");
            generator.write(this.level);
        }
        if (this.source != null) {
            generator.writeKey("source");
            generator.write(this.source.intValue());
        }
        if (this.reformat != null) {
            generator.writeKey("reformat");
            generator.write(this.reformat.booleanValue());
        }
        if (this.threshold != null) {
            generator.writeKey("threshold");
            this.threshold.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSlowlogSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::level, JsonpDeserializer.stringDeserializer(), "level");
        op.add(Builder::source, JsonpDeserializer.integerDeserializer(), "source");
        op.add(Builder::reformat, JsonpDeserializer.booleanDeserializer(), "reformat");
        op.add(Builder::threshold, SlowlogTresholds._DESERIALIZER, "threshold");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SlowlogSettings> {
        @Nullable
        private String level;
        @Nullable
        private Integer source;
        @Nullable
        private Boolean reformat;
        @Nullable
        private SlowlogTresholds threshold;

        public final Builder level(@Nullable String value) {
            this.level = value;
            return this;
        }

        public final Builder source(@Nullable Integer value) {
            this.source = value;
            return this;
        }

        public final Builder reformat(@Nullable Boolean value) {
            this.reformat = value;
            return this;
        }

        public final Builder threshold(@Nullable SlowlogTresholds value) {
            this.threshold = value;
            return this;
        }

        public final Builder threshold(Function<SlowlogTresholds.Builder, ObjectBuilder<SlowlogTresholds>> fn) {
            return this.threshold(fn.apply(new SlowlogTresholds.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SlowlogSettings build() {
            this._checkSingleUse();
            return new SlowlogSettings(this);
        }
    }
}

