/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.DataStreamLifecycleDownsampling;
import co.elastic.clients.elasticsearch.indices.DataStreamLifecycleRolloverConditions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamLifecycleWithRollover
implements JsonpSerializable {
    @Nullable
    private final Time dataRetention;
    @Nullable
    private final DataStreamLifecycleDownsampling downsampling;
    @Nullable
    private final DataStreamLifecycleRolloverConditions rollover;
    public static final JsonpDeserializer<DataStreamLifecycleWithRollover> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamLifecycleWithRollover::setupDataStreamLifecycleWithRolloverDeserializer);

    private DataStreamLifecycleWithRollover(Builder builder) {
        this.dataRetention = builder.dataRetention;
        this.downsampling = builder.downsampling;
        this.rollover = builder.rollover;
    }

    public static DataStreamLifecycleWithRollover of(Function<Builder, ObjectBuilder<DataStreamLifecycleWithRollover>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time dataRetention() {
        return this.dataRetention;
    }

    @Nullable
    public final DataStreamLifecycleDownsampling downsampling() {
        return this.downsampling;
    }

    @Nullable
    public final DataStreamLifecycleRolloverConditions rollover() {
        return this.rollover;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dataRetention != null) {
            generator.writeKey("data_retention");
            this.dataRetention.serialize(generator, mapper);
        }
        if (this.downsampling != null) {
            generator.writeKey("downsampling");
            this.downsampling.serialize(generator, mapper);
        }
        if (this.rollover != null) {
            generator.writeKey("rollover");
            this.rollover.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataStreamLifecycleWithRolloverDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataRetention, Time._DESERIALIZER, "data_retention");
        op.add(Builder::downsampling, DataStreamLifecycleDownsampling._DESERIALIZER, "downsampling");
        op.add(Builder::rollover, DataStreamLifecycleRolloverConditions._DESERIALIZER, "rollover");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamLifecycleWithRollover> {
        @Nullable
        private Time dataRetention;
        @Nullable
        private DataStreamLifecycleDownsampling downsampling;
        @Nullable
        private DataStreamLifecycleRolloverConditions rollover;

        public final Builder dataRetention(@Nullable Time value) {
            this.dataRetention = value;
            return this;
        }

        public final Builder dataRetention(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.dataRetention(fn.apply(new Time.Builder()).build());
        }

        public final Builder downsampling(@Nullable DataStreamLifecycleDownsampling value) {
            this.downsampling = value;
            return this;
        }

        public final Builder downsampling(Function<DataStreamLifecycleDownsampling.Builder, ObjectBuilder<DataStreamLifecycleDownsampling>> fn) {
            return this.downsampling(fn.apply(new DataStreamLifecycleDownsampling.Builder()).build());
        }

        public final Builder rollover(@Nullable DataStreamLifecycleRolloverConditions value) {
            this.rollover = value;
            return this;
        }

        public final Builder rollover(Function<DataStreamLifecycleRolloverConditions.Builder, ObjectBuilder<DataStreamLifecycleRolloverConditions>> fn) {
            return this.rollover(fn.apply(new DataStreamLifecycleRolloverConditions.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamLifecycleWithRollover build() {
            this._checkSingleUse();
            return new DataStreamLifecycleWithRollover(this);
        }
    }
}

