/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.SignificantTermsBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SignificantStringTermsBucket
extends SignificantTermsBucketBase {
    private final String key;
    public static final JsonpDeserializer<SignificantStringTermsBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SignificantStringTermsBucket::setupSignificantStringTermsBucketDeserializer);

    private SignificantStringTermsBucket(Builder builder) {
        super(builder);
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
    }

    public static SignificantStringTermsBucket of(Function<Builder, ObjectBuilder<SignificantStringTermsBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String key() {
        return this.key;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("key");
        generator.write(this.key);
    }

    protected static void setupSignificantStringTermsBucketDeserializer(ObjectDeserializer<Builder> op) {
        SignificantTermsBucketBase.setupSignificantTermsBucketBaseDeserializer(op);
        op.add(Builder::key, JsonpDeserializer.stringDeserializer(), "key");
    }

    public static class Builder
    extends SignificantTermsBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SignificantStringTermsBucket> {
        private String key;

        public final Builder key(String value) {
            this.key = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SignificantStringTermsBucket build() {
            this._checkSingleUse();
            return new SignificantStringTermsBucket(this);
        }
    }
}

