/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.endpoint;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.TrieCacheTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.base.cache.BaseDataCache;
import org.apache.shenyu.plugin.base.cache.MatchDataCache;
import org.apache.shenyu.plugin.base.cache.MetaDataCache;
import org.apache.shenyu.plugin.base.trie.ShenyuTrie;
import org.apache.shenyu.web.handler.ShenyuWebHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"/actuator"}, produces={"application/json", "application/xml"})
public class ShenyuControllerEndpoint {
    private final ShenyuWebHandler webHandler;

    public ShenyuControllerEndpoint(ShenyuWebHandler webHandler) {
        this.webHandler = webHandler;
    }

    @GetMapping(value={"/plugins"})
    public Flux<Map<String, Integer>> plugins() {
        List<ShenyuPlugin> plugins = this.webHandler.getPlugins();
        return Flux.just(plugins.stream().collect(Collectors.toMap(Object::toString, ShenyuPlugin::getOrder)));
    }

    @GetMapping(value={"/pluginData"})
    public Flux<Map<String, PluginData>> pluginDatas() {
        return Flux.just((Object)BaseDataCache.getInstance().getPluginMap());
    }

    @GetMapping(value={"/selectorData"})
    public Flux<Map<String, List<SelectorData>>> selectorData() {
        return Flux.just((Object)BaseDataCache.getInstance().getSelectorMap());
    }

    @GetMapping(value={"/ruleData"})
    public Flux<Map<String, List<RuleData>>> ruleData() {
        return Flux.just((Object)BaseDataCache.getInstance().getRuleMap());
    }

    @GetMapping(value={"/selectorMatchCache"})
    public Flux<Map<String, Map<String, SelectorData>>> getSelectorMatchCache() {
        return Flux.just((Object)MatchDataCache.getInstance().getSelectorMatchCache());
    }

    @GetMapping(value={"/ruleMatchCache"})
    public Flux<Map<String, Map<String, RuleData>>> getRuleMatchCache() {
        return Flux.just((Object)MatchDataCache.getInstance().getRuleMatchCache());
    }

    @GetMapping(value={"/metadata"})
    public Flux<Map<String, MetaData>> getMetadata() {
        return Flux.just((Object)MetaDataCache.getInstance().getMetaDataMap());
    }

    @GetMapping(value={"/metadataCache"})
    public Flux<Map<String, MetaData>> getMetaDataCache() {
        return Flux.just((Object)MetaDataCache.getInstance().getMetaDataCache());
    }

    @GetMapping(value={"/selectorTrie"})
    public Flux<Set<String>> getSelectorTrieKeys() {
        ShenyuTrie selectorTrie = (ShenyuTrie)SpringBeanUtils.getInstance().getBean(TrieCacheTypeEnum.SELECTOR.getTrieType());
        return Flux.just((Object)selectorTrie.getKeyRootKeys());
    }

    @GetMapping(value={"/ruleTrie"})
    public Flux<Set<String>> getRuleTrieKeys() {
        ShenyuTrie ruleTrie = (ShenyuTrie)SpringBeanUtils.getInstance().getBean(TrieCacheTypeEnum.RULE.getTrieType());
        return Flux.just((Object)ruleTrie.getKeyRootKeys());
    }
}

