/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer.collection;

import io.fury.Fury;
import io.fury.config.Language;
import io.fury.exception.FuryException;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassResolver;
import io.fury.serializer.ReplaceResolveSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.serializer.collection.AbstractCollectionSerializer;
import io.fury.serializer.collection.CollectionSerializer;
import io.fury.type.Type;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import io.fury.util.ReflectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentSkipListSet;

public class CollectionSerializers {
    public static void registerDefaultSerializers(Fury fury) {
        fury.registerSerializer(ArrayList.class, new ArrayListSerializer(fury));
        Class<List<?>> arrayAsListClass = Arrays.asList(1, 2).getClass();
        fury.registerSerializer(arrayAsListClass, new ArraysAsListSerializer(fury, arrayAsListClass));
        fury.registerSerializer(LinkedList.class, new CollectionSerializer<LinkedList>(fury, LinkedList.class, true));
        fury.registerSerializer(HashSet.class, new HashSetSerializer(fury));
        fury.registerSerializer(LinkedHashSet.class, new LinkedHashSetSerializer(fury));
        fury.registerSerializer(TreeSet.class, new SortedSetSerializer<TreeSet>(fury, TreeSet.class));
        fury.registerSerializer(Collections.EMPTY_LIST.getClass(), new EmptyListSerializer(fury, Collections.EMPTY_LIST.getClass()));
        fury.registerSerializer(Collections.emptySortedSet().getClass(), new EmptySortedSetSerializer(fury, Collections.emptySortedSet().getClass()));
        fury.registerSerializer(Collections.EMPTY_SET.getClass(), new EmptySetSerializer(fury, Collections.EMPTY_SET.getClass()));
        fury.registerSerializer(Collections.singletonList(null).getClass(), new CollectionsSingletonListSerializer(fury, Collections.singletonList(null).getClass()));
        fury.registerSerializer(Collections.singleton(null).getClass(), new CollectionsSingletonSetSerializer(fury, Collections.singleton(null).getClass()));
        fury.registerSerializer(ConcurrentSkipListSet.class, new ConcurrentSkipListSetSerializer(fury, ConcurrentSkipListSet.class));
        fury.registerSerializer(Vector.class, new VectorSerializer(fury, Vector.class));
        fury.registerSerializer(ArrayDeque.class, new ArrayDequeSerializer(fury, ArrayDeque.class));
        fury.registerSerializer(BitSet.class, new BitSetSerializer(fury, BitSet.class));
        fury.registerSerializer(PriorityQueue.class, new PriorityQueueSerializer(fury, PriorityQueue.class));
    }

    public static final class ArrayListSerializer
    extends CollectionSerializer<ArrayList> {
        public ArrayListSerializer(Fury fury) {
            super(fury, ArrayList.class, true);
        }

        @Override
        public short getXtypeId() {
            return Type.LIST.getId();
        }

        @Override
        public ArrayList newCollection(MemoryBuffer buffer) {
            this.numElements = buffer.readPositiveVarInt();
            ArrayList arrayList = new ArrayList(this.numElements);
            this.fury.getRefResolver().reference(arrayList);
            return arrayList;
        }
    }

    public static final class ArraysAsListSerializer
    extends CollectionSerializer<List<?>> {
        private static final long arrayFieldOffset;

        public ArraysAsListSerializer(Fury fury, Class<List<?>> cls) {
            super(fury, cls, false);
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        public void write(MemoryBuffer buffer, List<?> value) {
            try {
                Object[] array = (Object[])Platform.getObject(value, arrayFieldOffset);
                this.fury.writeRef(buffer, array);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void xwrite(MemoryBuffer buffer, List<?> value) {
            super.xwrite(buffer, value);
        }

        @Override
        public List<?> read(MemoryBuffer buffer) {
            Object[] array = (Object[])this.fury.readRef(buffer);
            Preconditions.checkNotNull(array);
            return Arrays.asList(array);
        }

        @Override
        public List<?> xread(MemoryBuffer buffer) {
            int numElements = buffer.readPositiveVarInt();
            Object[] arr = new Object[numElements];
            for (int i = 0; i < numElements; ++i) {
                Object elem;
                arr[i] = elem = this.fury.xreadRef(buffer);
            }
            return Arrays.asList(arr);
        }

        static {
            try {
                Field arrayField = Class.forName("java.util.Arrays$ArrayList").getDeclaredField("a");
                arrayFieldOffset = Platform.objectFieldOffset(arrayField);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class HashSetSerializer
    extends CollectionSerializer<HashSet> {
        public HashSetSerializer(Fury fury) {
            super(fury, HashSet.class, true);
        }

        @Override
        public short getXtypeId() {
            return Type.FURY_SET.getId();
        }

        @Override
        public HashSet newCollection(MemoryBuffer buffer) {
            this.numElements = buffer.readPositiveVarInt();
            HashSet hashSet = new HashSet(this.numElements);
            this.fury.getRefResolver().reference(hashSet);
            return hashSet;
        }
    }

    public static final class LinkedHashSetSerializer
    extends CollectionSerializer<LinkedHashSet> {
        public LinkedHashSetSerializer(Fury fury) {
            super(fury, LinkedHashSet.class, true);
        }

        @Override
        public short getXtypeId() {
            return Type.FURY_SET.getId();
        }

        @Override
        public LinkedHashSet newCollection(MemoryBuffer buffer) {
            this.numElements = buffer.readPositiveVarInt();
            LinkedHashSet hashSet = new LinkedHashSet(this.numElements);
            this.fury.getRefResolver().reference(hashSet);
            return hashSet;
        }
    }

    public static class SortedSetSerializer<T extends SortedSet>
    extends CollectionSerializer<T> {
        private MethodHandle constructor;

        public SortedSetSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, true);
            if (cls != TreeSet.class) {
                try {
                    this.constructor = ReflectionUtils.getCtrHandle(cls, Comparator.class);
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException(e);
                }
            }
        }

        @Override
        public Collection onCollectionWrite(MemoryBuffer buffer, T value) {
            buffer.writePositiveVarInt(value.size());
            this.fury.writeRef(buffer, value.comparator());
            return value;
        }

        public T newCollection(MemoryBuffer buffer) {
            SortedSet collection;
            this.numElements = buffer.readPositiveVarInt();
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            if (this.type == TreeSet.class) {
                collection = new TreeSet(comparator);
            } else {
                try {
                    collection = this.constructor.invoke(comparator);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            this.fury.getRefResolver().reference(collection);
            return (T)collection;
        }
    }

    public static final class EmptyListSerializer
    extends CollectionSerializer<List<?>> {
        public EmptyListSerializer(Fury fury, Class<List<?>> cls) {
            super(fury, cls, false);
        }

        @Override
        public void write(MemoryBuffer buffer, List<?> value) {
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, List<?> value) {
            buffer.writePositiveVarInt(0);
        }

        @Override
        public List<?> read(MemoryBuffer buffer) {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List<?> xread(MemoryBuffer buffer) {
            buffer.readPositiveVarInt();
            return Collections.EMPTY_LIST;
        }
    }

    public static final class EmptySortedSetSerializer
    extends CollectionSerializer<SortedSet<?>> {
        public EmptySortedSetSerializer(Fury fury, Class<SortedSet<?>> cls) {
            super(fury, cls, false);
        }

        @Override
        public void write(MemoryBuffer buffer, SortedSet<?> value) {
        }

        @Override
        public SortedSet<?> read(MemoryBuffer buffer) {
            return Collections.emptySortedSet();
        }
    }

    public static final class EmptySetSerializer
    extends CollectionSerializer<Set<?>> {
        public EmptySetSerializer(Fury fury, Class<Set<?>> cls) {
            super(fury, cls, false);
        }

        @Override
        public void write(MemoryBuffer buffer, Set<?> value) {
        }

        @Override
        public short getXtypeId() {
            return -Type.FURY_SET.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Set<?> value) {
            buffer.writePositiveVarInt(0);
        }

        @Override
        public Set<?> read(MemoryBuffer buffer) {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set<?> xread(MemoryBuffer buffer) {
            buffer.readPositiveVarInt();
            return Collections.EMPTY_SET;
        }
    }

    public static final class CollectionsSingletonListSerializer
    extends CollectionSerializer<List<?>> {
        public CollectionsSingletonListSerializer(Fury fury, Class<List<?>> cls) {
            super(fury, cls, false);
        }

        @Override
        public void write(MemoryBuffer buffer, List<?> value) {
            this.fury.writeRef(buffer, value.get(0));
        }

        @Override
        public short getXtypeId() {
            return -Type.LIST.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, List<?> value) {
            buffer.writePositiveVarInt(1);
            this.fury.xwriteRef(buffer, value.get(0));
        }

        @Override
        public List<?> read(MemoryBuffer buffer) {
            return Collections.singletonList(this.fury.readRef(buffer));
        }

        @Override
        public List<?> xread(MemoryBuffer buffer) {
            buffer.readPositiveVarInt();
            return Collections.singletonList(this.fury.xreadRef(buffer));
        }
    }

    public static final class CollectionsSingletonSetSerializer
    extends CollectionSerializer<Set<?>> {
        public CollectionsSingletonSetSerializer(Fury fury, Class<Set<?>> cls) {
            super(fury, cls, false);
        }

        @Override
        public void write(MemoryBuffer buffer, Set<?> value) {
            this.fury.writeRef(buffer, value.iterator().next());
        }

        @Override
        public short getXtypeId() {
            return -Type.FURY_SET.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Set<?> value) {
            buffer.writePositiveVarInt(1);
            this.fury.xwriteRef(buffer, value.iterator().next());
        }

        @Override
        public Set<?> read(MemoryBuffer buffer) {
            return Collections.singleton(this.fury.readRef(buffer));
        }

        @Override
        public Set<?> xread(MemoryBuffer buffer) {
            buffer.readPositiveVarInt();
            return Collections.singleton(this.fury.xreadRef(buffer));
        }
    }

    public static final class ConcurrentSkipListSetSerializer
    extends SortedSetSerializer<ConcurrentSkipListSet> {
        public ConcurrentSkipListSetSerializer(Fury fury, Class<ConcurrentSkipListSet> cls) {
            super(fury, cls);
        }

        @Override
        public ConcurrentSkipListSet newCollection(MemoryBuffer buffer) {
            this.numElements = buffer.readPositiveVarInt();
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            ConcurrentSkipListSet skipListSet = new ConcurrentSkipListSet(comparator);
            this.fury.getRefResolver().reference(skipListSet);
            return skipListSet;
        }
    }

    public static final class VectorSerializer
    extends CollectionSerializer<Vector> {
        public VectorSerializer(Fury fury, Class<Vector> cls) {
            super(fury, cls, true);
        }

        @Override
        public Vector newCollection(MemoryBuffer buffer) {
            this.numElements = buffer.readPositiveVarInt();
            Vector vector = new Vector(this.numElements);
            this.fury.getRefResolver().reference(vector);
            return vector;
        }
    }

    public static final class ArrayDequeSerializer
    extends CollectionSerializer<ArrayDeque> {
        public ArrayDequeSerializer(Fury fury, Class<ArrayDeque> cls) {
            super(fury, cls, true);
        }

        @Override
        public ArrayDeque newCollection(MemoryBuffer buffer) {
            this.numElements = buffer.readPositiveVarInt();
            ArrayDeque deque = new ArrayDeque(this.numElements);
            this.fury.getRefResolver().reference(deque);
            return deque;
        }
    }

    public static class BitSetSerializer
    extends Serializer<BitSet> {
        public BitSetSerializer(Fury fury, Class<BitSet> type) {
            super(fury, type);
        }

        @Override
        public void write(MemoryBuffer buffer, BitSet set) {
            long[] values = set.toLongArray();
            buffer.writePrimitiveArrayWithSizeEmbedded(values, Platform.LONG_ARRAY_OFFSET, Math.multiplyExact(values.length, 8));
        }

        @Override
        public BitSet read(MemoryBuffer buffer) {
            long[] values = buffer.readLongsWithSizeEmbedded();
            return BitSet.valueOf(values);
        }
    }

    public static class PriorityQueueSerializer
    extends CollectionSerializer<PriorityQueue> {
        public PriorityQueueSerializer(Fury fury, Class<PriorityQueue> cls) {
            super(fury, cls, true);
        }

        @Override
        public Collection onCollectionWrite(MemoryBuffer buffer, PriorityQueue value) {
            buffer.writePositiveVarInt(value.size());
            this.fury.writeRef(buffer, value.comparator());
            return value;
        }

        @Override
        public PriorityQueue newCollection(MemoryBuffer buffer) {
            this.numElements = buffer.readPositiveVarInt();
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            PriorityQueue queue = new PriorityQueue(comparator);
            this.fury.getRefResolver().reference(queue);
            return queue;
        }
    }

    public static final class JDKCompatibleCollectionSerializer<T>
    extends AbstractCollectionSerializer<T> {
        private final Serializer serializer;

        public JDKCompatibleCollectionSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false);
            Class serializerType = ClassResolver.useReplaceResolveSerializer(cls) ? ReplaceResolveSerializer.class : fury.getDefaultJDKStreamSerializerType();
            this.serializer = Serializers.newSerializer(fury, cls, serializerType);
        }

        @Override
        public Collection onCollectionWrite(MemoryBuffer buffer, T value) {
            throw new IllegalStateException();
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return this.serializer.read(buffer);
        }

        @Override
        public T onCollectionRead(Collection collection) {
            throw new IllegalStateException();
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.serializer.write(buffer, value);
        }
    }

    public static final class DefaultJavaCollectionSerializer<T>
    extends AbstractCollectionSerializer<T> {
        private Serializer<T> dataSerializer;

        public DefaultJavaCollectionSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false);
            Preconditions.checkArgument(fury.getLanguage() == Language.JAVA, "Python default collection serializer should use " + CollectionSerializer.class);
            fury.getClassResolver().setSerializer(cls, this);
            Class<? extends Serializer> serializerClass = fury.getClassResolver().getObjectSerializerClass(cls, sc -> {
                this.dataSerializer = Serializers.newSerializer(fury, cls, sc);
            });
            this.dataSerializer = Serializers.newSerializer(fury, cls, serializerClass);
        }

        @Override
        public Collection onCollectionWrite(MemoryBuffer buffer, T value) {
            throw new IllegalStateException();
        }

        @Override
        public T onCollectionRead(Collection collection) {
            throw new IllegalStateException();
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.dataSerializer.write(buffer, value);
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return this.dataSerializer.read(buffer);
        }
    }

    public static class EnumSetSerializer
    extends CollectionSerializer<EnumSet> {
        public EnumSetSerializer(Fury fury, Class<EnumSet> type) {
            super(fury, type, false);
        }

        @Override
        public void write(MemoryBuffer buffer, EnumSet object) {
            Class<?> elemClass;
            if (object.isEmpty()) {
                EnumSet tmp = EnumSet.complementOf(object);
                if (tmp.isEmpty()) {
                    throw new FuryException("An EnumSet must have a defined Enum to be serialized.");
                }
                elemClass = tmp.iterator().next().getClass();
            } else {
                elemClass = object.iterator().next().getClass();
            }
            this.fury.getClassResolver().writeClassAndUpdateCache(buffer, elemClass);
            Serializer<?> serializer = this.fury.getClassResolver().getSerializer(elemClass);
            buffer.writePositiveVarIntAligned(object.size());
            for (Object element : object) {
                serializer.write(buffer, element);
            }
        }

        @Override
        public EnumSet read(MemoryBuffer buffer) {
            Class<?> elemClass = this.fury.getClassResolver().readClassInfo(buffer).getCls();
            EnumSet<?> object = EnumSet.noneOf(elemClass);
            Serializer<?> elemSerializer = this.fury.getClassResolver().getSerializer(elemClass);
            int length = buffer.readPositiveAlignedVarInt();
            for (int i = 0; i < length; ++i) {
                object.add(elemSerializer.read(buffer));
            }
            return object;
        }
    }
}

