/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.filter.FilterInvoker;

public class ConsumerInvoker
extends FilterInvoker {
    private ConsumerBootstrap consumerBootstrap;

    public ConsumerInvoker(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap.getConsumerConfig());
        this.consumerBootstrap = consumerBootstrap;
    }

    @Override
    public SofaResponse invoke(SofaRequest sofaRequest) throws SofaRpcException {
        RpcInvokeContext.getContext().put("_consumer_invoke_start_time_nano", System.nanoTime());
        ProviderInfo providerInfo = RpcInternalContext.getContext().getProviderInfo();
        String appName = providerInfo.getStaticAttr("appName");
        if (StringUtils.isNotEmpty(appName)) {
            sofaRequest.setTargetAppName(appName);
        }
        SofaResponse sofaResponse = this.consumerBootstrap.getCluster().sendMsg(providerInfo, sofaRequest);
        RpcInvokeContext.getContext().put("_consumer_invoke_end_time_nano", System.nanoTime());
        return sofaResponse;
    }
}

