/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.cache;

import com.alipay.sofa.rpc.common.utils.ClassLoaderUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ReflectCache {
    static final ConcurrentMap<String, ClassLoader> APPNAME_CLASSLOADER_MAP = new ConcurrentHashMap<String, ClassLoader>();
    static final ConcurrentMap<String, ClassLoader> SERVICE_CLASSLOADER_MAP = new ConcurrentHashMap<String, ClassLoader>();
    static final ConcurrentMap<String, WeakHashMap<ClassLoader, Class>> CLASS_CACHE = new ConcurrentHashMap<String, WeakHashMap<ClassLoader, Class>>();
    static final ConcurrentMap<Class, String> TYPE_STR_CACHE = new ConcurrentHashMap<Class, String>();
    static final ConcurrentMap<String, ConcurrentHashMap<String, Method>> NOT_OVERLOAD_METHOD_CACHE = new ConcurrentHashMap<String, ConcurrentHashMap<String, Method>>();
    static final ConcurrentMap<String, ConcurrentHashMap<String, String[]>> NOT_OVERLOAD_METHOD_SIGS_CACHE = new ConcurrentHashMap<String, ConcurrentHashMap<String, String[]>>();
    static final ConcurrentMap<String, ConcurrentHashMap<String, Method>> OVERLOAD_METHOD_CACHE = new ConcurrentHashMap<String, ConcurrentHashMap<String, Method>>();

    public static void registerAppClassLoader(String appName, ClassLoader classloader) {
        APPNAME_CLASSLOADER_MAP.put(appName, classloader);
    }

    public static ClassLoader getAppClassLoader(String appName) {
        ClassLoader appClassLoader = (ClassLoader)APPNAME_CLASSLOADER_MAP.get(appName);
        if (appClassLoader == null) {
            return ClassLoaderUtils.getCurrentClassLoader();
        }
        return appClassLoader;
    }

    public static void registerServiceClassLoader(String serviceUniqueName, ClassLoader classloader) {
        SERVICE_CLASSLOADER_MAP.put(serviceUniqueName, classloader);
    }

    public static ClassLoader unRegisterServiceClassLoader(String serviceUniqueName) {
        return (ClassLoader)SERVICE_CLASSLOADER_MAP.remove(serviceUniqueName);
    }

    public static ClassLoader getServiceClassLoader(String serviceUniqueName) {
        ClassLoader appClassLoader = (ClassLoader)SERVICE_CLASSLOADER_MAP.get(serviceUniqueName);
        if (appClassLoader == null) {
            return ClassLoaderUtils.getCurrentClassLoader();
        }
        return appClassLoader;
    }

    public static void putClassCache(String typeStr, Class clazz) {
        CLASS_CACHE.putIfAbsent(typeStr, new WeakHashMap());
        ((WeakHashMap)CLASS_CACHE.get(typeStr)).put(clazz.getClassLoader(), clazz);
    }

    public static Class getClassCache(String typeStr) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            return null;
        }
        Map temp = (Map)CLASS_CACHE.get(typeStr);
        return temp == null ? null : (Class)temp.get(classLoader);
    }

    public static void putTypeStrCache(Class clazz, String typeStr) {
        TYPE_STR_CACHE.put(clazz, typeStr);
    }

    public static String getTypeStrCache(Class clazz) {
        return (String)TYPE_STR_CACHE.get(clazz);
    }

    public static void putMethodCache(String serviceName, Method method) {
        ConcurrentHashMap old;
        ConcurrentHashMap<String, Method> cache = (ConcurrentHashMap<String, Method>)NOT_OVERLOAD_METHOD_CACHE.get(serviceName);
        if (cache == null && (old = NOT_OVERLOAD_METHOD_CACHE.putIfAbsent(serviceName, cache = new ConcurrentHashMap<String, Method>())) != null) {
            cache = old;
        }
        cache.put(method.getName(), method);
    }

    public static Method getMethodCache(String serviceName, String methodName) {
        ConcurrentHashMap methods = (ConcurrentHashMap)NOT_OVERLOAD_METHOD_CACHE.get(serviceName);
        return methods == null ? null : (Method)methods.get(methodName);
    }

    public static void invalidateMethodCache(String serviceName) {
        NOT_OVERLOAD_METHOD_CACHE.remove(serviceName);
    }

    public static void putMethodSigsCache(String serviceName, String methodName, String[] argSigs) {
        ConcurrentHashMap old;
        ConcurrentHashMap<String, String[]> cacheSigs = (ConcurrentHashMap<String, String[]>)NOT_OVERLOAD_METHOD_SIGS_CACHE.get(serviceName);
        if (cacheSigs == null && (old = NOT_OVERLOAD_METHOD_SIGS_CACHE.putIfAbsent(serviceName, cacheSigs = new ConcurrentHashMap<String, String[]>())) != null) {
            cacheSigs = old;
        }
        cacheSigs.put(methodName, argSigs);
    }

    public static String[] getMethodSigsCache(String serviceName, String methodName) {
        ConcurrentHashMap methods = (ConcurrentHashMap)NOT_OVERLOAD_METHOD_SIGS_CACHE.get(serviceName);
        return methods == null ? null : (String[])methods.get(methodName);
    }

    public static void invalidateMethodSigsCache(String serviceName) {
        NOT_OVERLOAD_METHOD_SIGS_CACHE.remove(serviceName);
    }

    public static void putOverloadMethodCache(String serviceName, Method method) {
        ConcurrentHashMap old;
        ConcurrentHashMap<String, Method> cache = (ConcurrentHashMap<String, Method>)OVERLOAD_METHOD_CACHE.get(serviceName);
        if (cache == null && (old = OVERLOAD_METHOD_CACHE.putIfAbsent(serviceName, cache = new ConcurrentHashMap<String, Method>())) != null) {
            cache = old;
        }
        StringBuilder mSigs = new StringBuilder(128);
        mSigs.append(method.getName());
        for (Class<?> paramType : method.getParameterTypes()) {
            mSigs.append(paramType.getName());
        }
        cache.put(mSigs.toString(), method);
    }

    public static Method getOverloadMethodCache(String serviceName, String methodName, String[] methodSigs) {
        ConcurrentHashMap methods = (ConcurrentHashMap)OVERLOAD_METHOD_CACHE.get(serviceName);
        if (methods == null) {
            return null;
        }
        StringBuilder mSigs = new StringBuilder(128);
        mSigs.append(methodName);
        for (String methodSign : methodSigs) {
            mSigs.append(methodSign);
        }
        return (Method)methods.get(mSigs.toString());
    }

    public static void invalidateOverloadMethodCache(String serviceName) {
        OVERLOAD_METHOD_CACHE.remove(serviceName);
    }

    static void clearAll() {
        CLASS_CACHE.clear();
        TYPE_STR_CACHE.clear();
        APPNAME_CLASSLOADER_MAP.clear();
        SERVICE_CLASSLOADER_MAP.clear();
        NOT_OVERLOAD_METHOD_CACHE.clear();
        NOT_OVERLOAD_METHOD_SIGS_CACHE.clear();
        OVERLOAD_METHOD_CACHE.clear();
    }
}

