/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.tcp;

import com.google.common.eventbus.EventBus;
import io.netty.channel.ChannelHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.protocol.tcp.BootstrapServer;
import org.apache.shenyu.protocol.tcp.TcpServerConfiguration;
import org.apache.shenyu.protocol.tcp.connection.ActivityConnectionObserver;
import org.apache.shenyu.protocol.tcp.connection.Bridge;
import org.apache.shenyu.protocol.tcp.connection.ConnectionContext;
import org.apache.shenyu.protocol.tcp.connection.DefaultConnectionConfigProvider;
import org.apache.shenyu.protocol.tcp.connection.TcpConnectionBridge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.DisposableServer;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpServer;

public class TcpBootstrapServer
implements BootstrapServer {
    private static final Logger LOG = LoggerFactory.getLogger(TcpBootstrapServer.class);
    private Bridge bridge;
    private ConnectionContext connectionContext;
    private LoopResources loopResources;
    private DisposableServer server;
    private final EventBus eventBus;

    public TcpBootstrapServer(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public void start(TcpServerConfiguration tcpServerConfiguration) {
        String loadBalanceAlgorithm = tcpServerConfiguration.getProps().getOrDefault((Object)"loadBalance", "random").toString();
        String bossGroupThreadCount = tcpServerConfiguration.getProps().getOrDefault((Object)"bossGroupThreadCount", "1").toString();
        String workerGroupThreadCount = tcpServerConfiguration.getProps().getOrDefault((Object)"workerGroupThreadCount", "12").toString();
        DefaultConnectionConfigProvider connectionConfigProvider = new DefaultConnectionConfigProvider(loadBalanceAlgorithm, tcpServerConfiguration.getPluginSelectorName());
        this.bridge = new TcpConnectionBridge();
        this.connectionContext = new ConnectionContext(connectionConfigProvider);
        this.connectionContext.init(tcpServerConfiguration.getProps());
        this.loopResources = LoopResources.create((String)("shenyu-tcp-bootstrap-server-" + tcpServerConfiguration.getPort()), (int)Integer.parseInt(bossGroupThreadCount), (int)Integer.parseInt(workerGroupThreadCount), (boolean)true);
        TcpServer tcpServer = ((TcpServer)((TcpServer)TcpServer.create().doOnChannelInit((connObserver, channel, remoteAddress) -> channel.pipeline().addFirst(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO)}))).wiretap(true).observe((c, s) -> LOG.info("connection={}|status={}", (Object)c, (Object)s))).doOnConnection(this::bridgeConnections).port(tcpServerConfiguration.getPort()).runOn(this.loopResources);
        this.server = tcpServer.bindNow();
    }

    private void bridgeConnections(Connection serverConn) {
        LOG.info("Starting proxy client ={}", (Object)serverConn);
        SocketAddress socketAddress = serverConn.channel().remoteAddress();
        ActivityConnectionObserver connectionObserver = new ActivityConnectionObserver("TcpClient");
        this.eventBus.register((Object)connectionObserver);
        Mono<Connection> client = this.connectionContext.getTcpClientConnection(this.getIp(socketAddress), connectionObserver);
        client.subscribe(clientConn -> this.bridge.bridge(serverConn, (Connection)clientConn));
    }

    private String getIp(SocketAddress socketAddress) {
        if (Objects.isNull(socketAddress)) {
            throw new NullPointerException("remoteAddress is null");
        }
        String address = socketAddress.toString();
        return address.substring(1, address.indexOf(58));
    }

    @Override
    public void removeCommonUpstream(List<DiscoveryUpstreamData> removeList) {
        this.eventBus.post(removeList);
    }

    @Override
    public void shutdown() {
        this.server.disposeNow();
        this.loopResources.dispose();
    }
}

