/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.exception.mapper;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;
import org.apache.dubbo.rpc.protocol.rest.exception.mapper.ExceptionHandler;
import org.apache.dubbo.rpc.protocol.rest.exception.mapper.ExceptionHandlerResult;
import org.apache.dubbo.rpc.protocol.rest.exception.mapper.ExceptionMapper;
import org.apache.dubbo.rpc.protocol.rest.util.ReflectUtils;

public class RestEasyExceptionMapper
extends ExceptionMapper {
    private final Map<Class<?>, javax.ws.rs.ext.ExceptionMapper> exceptionMappers = new ConcurrentHashMap();

    @Override
    protected List<Method> getExceptionHandlerMethods(Class<?> exceptionHandler) {
        if (!javax.ws.rs.ext.ExceptionMapper.class.isAssignableFrom(exceptionHandler)) {
            return super.getExceptionHandlerMethods(exceptionHandler);
        }
        List<Method> methods = ReflectUtils.getMethodByNameList(exceptionHandler, "toResponse");
        return methods;
    }

    @Override
    protected Map getExceptionHandlerMap(Object handler) {
        if (handler instanceof ExceptionHandler) {
            return super.getExceptionHandlerMap(handler);
        }
        return this.exceptionMappers;
    }

    @Override
    public ExceptionHandlerResult exceptionToResult(Object throwable) {
        Object exceptionMapper = this.getExceptionHandler(throwable.getClass());
        if (exceptionMapper == null || exceptionMapper instanceof ExceptionHandler) {
            return super.exceptionToResult(throwable);
        }
        Response response = ((javax.ws.rs.ext.ExceptionMapper)exceptionMapper).toResponse((Throwable)throwable);
        return ExceptionHandlerResult.build().setStatus(response.getStatus()).setEntity(response.getEntity());
    }
}

