/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.definition.ServiceDefinitionBuilder;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;

public class StubServiceDescriptor
implements ServiceDescriptor {
    private final String interfaceName;
    private final Class<?> serviceInterfaceClass;
    private final Map<String, List<MethodDescriptor>> methods = new HashMap<String, List<MethodDescriptor>>();
    private final Map<String, Map<String, MethodDescriptor>> descToMethods = new HashMap<String, Map<String, MethodDescriptor>>();
    private final ConcurrentNavigableMap<String, FullServiceDefinition> serviceDefinitions = new ConcurrentSkipListMap<String, FullServiceDefinition>();

    public StubServiceDescriptor(String interfaceName, Class<?> interfaceClass) {
        this.interfaceName = interfaceName;
        this.serviceInterfaceClass = interfaceClass;
    }

    public void addMethod(MethodDescriptor methodDescriptor) {
        this.methods.put(methodDescriptor.getMethodName(), Collections.singletonList(methodDescriptor));
        Map descMap = this.descToMethods.computeIfAbsent(methodDescriptor.getMethodName(), k -> new HashMap());
        descMap.put(methodDescriptor.getParamDesc(), methodDescriptor);
    }

    @Override
    public FullServiceDefinition getFullServiceDefinition(String serviceKey) {
        return this.serviceDefinitions.computeIfAbsent(serviceKey, k -> ServiceDefinitionBuilder.buildFullDefinition(this.serviceInterfaceClass, Collections.emptyMap()));
    }

    @Override
    public String getInterfaceName() {
        return this.interfaceName;
    }

    @Override
    public Class<?> getServiceInterfaceClass() {
        return this.serviceInterfaceClass;
    }

    @Override
    public Set<MethodDescriptor> getAllMethods() {
        HashSet<MethodDescriptor> methodModels = new HashSet<MethodDescriptor>();
        this.methods.forEach((k, v) -> methodModels.addAll((Collection<MethodDescriptor>)v));
        return methodModels;
    }

    @Override
    public MethodDescriptor getMethod(String methodName, String params) {
        Map<String, MethodDescriptor> methods = this.descToMethods.get(methodName);
        if (CollectionUtils.isNotEmptyMap(methods)) {
            return methods.get(params);
        }
        return null;
    }

    @Override
    public MethodDescriptor getMethod(String methodName, Class<?>[] paramTypes) {
        List<MethodDescriptor> methodModels = this.methods.get(methodName);
        if (CollectionUtils.isNotEmpty(methodModels)) {
            for (MethodDescriptor descriptor : methodModels) {
                if (!Arrays.equals(paramTypes, descriptor.getParameterClasses())) continue;
                return descriptor;
            }
        }
        return null;
    }

    @Override
    public List<MethodDescriptor> getMethods(String methodName) {
        return this.methods.get(methodName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StubServiceDescriptor that = (StubServiceDescriptor)o;
        return Objects.equals(this.interfaceName, that.interfaceName) && Objects.equals(this.serviceInterfaceClass, that.serviceInterfaceClass) && Objects.equals(this.methods, that.methods) && Objects.equals(this.descToMethods, that.descToMethods);
    }

    public int hashCode() {
        return Objects.hash(this.interfaceName, this.serviceInterfaceClass, this.methods, this.descToMethods);
    }
}

