/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.AbstractCacheManager;
import org.apache.dubbo.rpc.model.ScopeModel;

public class MappingCacheManager
extends AbstractCacheManager<Set<String>> {
    private static final String DEFAULT_FILE_NAME = ".mapping";
    private static final int DEFAULT_ENTRY_SIZE = 10000;

    public static MappingCacheManager getInstance(ScopeModel scopeModel) {
        return scopeModel.getBeanFactory().getOrRegisterBean(MappingCacheManager.class);
    }

    public MappingCacheManager(boolean enableFileCache, String name, ScheduledExecutorService executorService) {
        String rawEntrySize;
        int entrySize;
        String filePath = System.getProperty("dubbo.mapping.cache.filePath");
        String fileName = System.getProperty("dubbo.mapping.cache.fileName");
        if (StringUtils.isEmpty(fileName)) {
            fileName = DEFAULT_FILE_NAME;
        }
        if (StringUtils.isNotEmpty(name)) {
            fileName = fileName + "." + name;
        }
        entrySize = (entrySize = StringUtils.parseInteger(rawEntrySize = System.getProperty("dubbo.mapping.cache.entrySize"))) == 0 ? 10000 : entrySize;
        String rawMaxFileSize = System.getProperty("dubbo.mapping.cache.maxFileSize");
        long maxFileSize = StringUtils.parseLong(rawMaxFileSize);
        this.init(enableFileCache, filePath, fileName, entrySize, maxFileSize, 50, executorService);
    }

    @Override
    protected Set<String> toValueType(String value) {
        return new HashSet<String>(JsonUtils.toJavaList(value, String.class));
    }

    @Override
    protected String getName() {
        return "mapping";
    }
}

