/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.bootstrap.builders.InternalServiceConfigBuilder;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.client.metadata.MetadataServiceDelegation;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigurableMetadataServiceExporter {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private MetadataServiceDelegation metadataService;
    private volatile ServiceConfig<MetadataService> serviceConfig;
    private final ApplicationModel applicationModel;

    public ConfigurableMetadataServiceExporter(ApplicationModel applicationModel, MetadataServiceDelegation metadataService) {
        this.applicationModel = applicationModel;
        this.metadataService = metadataService;
    }

    public synchronized ConfigurableMetadataServiceExporter export() {
        if (this.serviceConfig == null || !this.isExported()) {
            ExecutorService internalServiceExecutor = this.applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class).getInternalServiceExecutor();
            this.serviceConfig = InternalServiceConfigBuilder.newBuilder(this.applicationModel).interfaceClass(MetadataService.class).protocol(this.getApplicationConfig().getMetadataServiceProtocol(), "metadata-service-protocol").port(this.getApplicationConfig().getMetadataServicePort(), "metadata-service-port").registryId("internal-metadata-registry").executor(internalServiceExecutor).ref(this.metadataService).build(configConsumer -> configConsumer.setMethods(this.generateMethodConfig()));
            this.serviceConfig.export();
            this.metadataService.setMetadataURL(this.serviceConfig.getExportedUrls().get(0));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("The MetadataService exports urls : " + this.serviceConfig.getExportedUrls());
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("5-26", "", "", "The MetadataService has been exported : " + this.serviceConfig.getExportedUrls());
        }
        return this;
    }

    public ConfigurableMetadataServiceExporter unexport() {
        if (this.isExported()) {
            this.serviceConfig.unexport();
            this.metadataService.setMetadataURL(null);
        }
        return this;
    }

    public boolean isExported() {
        return this.serviceConfig != null && this.serviceConfig.isExported() && !this.serviceConfig.isUnexported();
    }

    private ApplicationConfig getApplicationConfig() {
        return this.applicationModel.getApplicationConfigManager().getApplication().get();
    }

    private List<MethodConfig> generateMethodConfig() {
        MethodConfig methodConfig = new MethodConfig();
        methodConfig.setName("getAndListenInstanceMetadata");
        ArgumentConfig argumentConfig = new ArgumentConfig();
        argumentConfig.setIndex(1);
        argumentConfig.setCallback(true);
        methodConfig.setArguments(Collections.singletonList(argumentConfig));
        return Collections.singletonList(methodConfig);
    }

    public void setMetadataService(MetadataServiceDelegation metadataService) {
        this.metadataService = metadataService;
    }

    public List<URL> getExportedURLs() {
        return this.serviceConfig != null ? this.serviceConfig.getExportedUrls() : Collections.emptyList();
    }
}

