/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.bootstrap.builders;

import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.bootstrap.builders.AbstractBuilder;
import org.apache.dubbo.config.nested.AggregationConfig;
import org.apache.dubbo.config.nested.HistogramConfig;
import org.apache.dubbo.config.nested.PrometheusConfig;

public class MetricsBuilder
extends AbstractBuilder<MetricsConfig, MetricsBuilder> {
    private String protocol;
    private Boolean enableJvm;
    private Boolean enableThreadpool;
    private Boolean enableRegistry;
    private Boolean enableMetadata;
    private Boolean exportMetricsService;
    private Boolean enableMetricsInit;
    private Boolean enableCollectorSync;
    private Integer collectorSyncPeriod;
    private PrometheusConfig prometheus;
    private AggregationConfig aggregation;
    private HistogramConfig histogram;
    private String exportServiceProtocol;
    private Integer exportServicePort;
    private Boolean useGlobalRegistry;
    private Boolean enableRpc;
    private String rpcLevel;

    public static MetricsBuilder newBuilder() {
        return new MetricsBuilder();
    }

    public MetricsBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this.getThis();
    }

    public MetricsBuilder enableJvm(Boolean enableJvm) {
        this.enableJvm = enableJvm;
        return this.getThis();
    }

    public MetricsBuilder enableThreadPool(Boolean enableThreadPool) {
        this.enableThreadpool = enableThreadPool;
        return this.getThis();
    }

    public MetricsBuilder enableRegistry(Boolean enableRegistry) {
        this.enableRegistry = enableRegistry;
        return this.getThis();
    }

    public MetricsBuilder enableMetadata(Boolean enableMetadata) {
        this.enableMetadata = enableMetadata;
        return this.getThis();
    }

    public MetricsBuilder exportMetricsService(Boolean exportMetricsService) {
        this.exportMetricsService = exportMetricsService;
        return this.getThis();
    }

    public MetricsBuilder enableMetricsInit(Boolean enableMetricsInit) {
        this.enableMetricsInit = enableMetricsInit;
        return this.getThis();
    }

    public MetricsBuilder enableCollectorSync(Boolean enableCollectorSync) {
        this.enableCollectorSync = enableCollectorSync;
        return this.getThis();
    }

    public MetricsBuilder collectorSyncPeriod(Integer collectorSyncPeriod) {
        this.collectorSyncPeriod = collectorSyncPeriod;
        return this.getThis();
    }

    public MetricsBuilder prometheus(PrometheusConfig prometheus) {
        this.prometheus = prometheus;
        return this.getThis();
    }

    public MetricsBuilder aggregation(AggregationConfig aggregation) {
        this.aggregation = aggregation;
        return this.getThis();
    }

    public MetricsBuilder histogram(HistogramConfig histogram) {
        this.histogram = histogram;
        return this.getThis();
    }

    public MetricsBuilder exportServiceProtocol(String exportServiceProtocol) {
        this.exportServiceProtocol = exportServiceProtocol;
        return this.getThis();
    }

    public MetricsBuilder exportServicePort(Integer exportServicePort) {
        this.exportServicePort = exportServicePort;
        return this.getThis();
    }

    public MetricsBuilder useGlobalRegistry(Boolean useGlobalRegistry) {
        this.useGlobalRegistry = useGlobalRegistry;
        return this.getThis();
    }

    public MetricsBuilder enableRpc(Boolean enableRpc) {
        this.enableRpc = enableRpc;
        return this.getThis();
    }

    public MetricsBuilder rpcLevel(String rpcLevel) {
        this.rpcLevel = rpcLevel;
        return this.getThis();
    }

    @Override
    public MetricsConfig build() {
        MetricsConfig metrics = new MetricsConfig();
        super.build(metrics);
        metrics.setProtocol(this.protocol);
        metrics.setEnableJvm(this.enableJvm);
        metrics.setEnableThreadpool(this.enableThreadpool);
        metrics.setEnableRegistry(this.enableRegistry);
        metrics.setEnableMetadata(this.enableMetadata);
        metrics.setExportMetricsService(this.exportMetricsService);
        metrics.setEnableMetricsInit(this.enableMetricsInit);
        metrics.setEnableCollectorSync(this.enableCollectorSync);
        metrics.setCollectorSyncPeriod(this.collectorSyncPeriod);
        metrics.setPrometheus(this.prometheus);
        metrics.setAggregation(this.aggregation);
        metrics.setHistogram(this.histogram);
        metrics.setExportServiceProtocol(this.exportServiceProtocol);
        metrics.setExportServicePort(this.exportServicePort);
        metrics.setUseGlobalRegistry(this.useGlobalRegistry);
        metrics.setEnableRpc(this.enableRpc);
        metrics.setRpcLevel(this.rpcLevel);
        return metrics;
    }

    @Override
    protected MetricsBuilder getThis() {
        return this;
    }
}

