/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NamedThreadFactory;

public class ExecutorUtil {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ExecutorUtil.class);
    private static final ThreadPoolExecutor SHUTDOWN_EXECUTOR = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), new NamedThreadFactory("Close-ExecutorService-Timer", true));

    public static boolean isTerminated(Executor executor) {
        if (!(executor instanceof ExecutorService)) {
            return false;
        }
        return ((ExecutorService)executor).isTerminated();
    }

    public static boolean isShutdown(Executor executor) {
        if (!(executor instanceof ExecutorService)) {
            return false;
        }
        return ((ExecutorService)executor).isShutdown();
    }

    public static void gracefulShutdown(Executor executor, int timeout) {
        if (!(executor instanceof ExecutorService) || ExecutorUtil.isTerminated(executor)) {
            return;
        }
        ExecutorService es = (ExecutorService)executor;
        try {
            es.shutdown();
        }
        catch (NullPointerException | SecurityException ex2) {
            return;
        }
        try {
            if (!es.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                es.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            es.shutdownNow();
            Thread.currentThread().interrupt();
        }
        if (!ExecutorUtil.isTerminated(es)) {
            ExecutorUtil.newThreadToCloseExecutor(es);
        }
    }

    public static void shutdownNow(Executor executor, int timeout) {
        if (!(executor instanceof ExecutorService) || ExecutorUtil.isTerminated(executor)) {
            return;
        }
        ExecutorService es = (ExecutorService)executor;
        try {
            es.shutdownNow();
        }
        catch (NullPointerException | SecurityException ex2) {
            return;
        }
        try {
            es.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (!ExecutorUtil.isTerminated(es)) {
            ExecutorUtil.newThreadToCloseExecutor(es);
        }
    }

    private static void newThreadToCloseExecutor(ExecutorService es) {
        if (!ExecutorUtil.isTerminated(es)) {
            SHUTDOWN_EXECUTOR.execute(() -> {
                try {
                    for (int i = 0; i < 1000; ++i) {
                        es.shutdownNow();
                        if (!es.awaitTermination(10L, TimeUnit.MILLISECONDS)) {
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable e) {
                    logger.warn("0-17", "", "", e.getMessage(), e);
                }
            });
        }
    }

    public static URL setThreadName(URL url, String defaultName) {
        String name = url.getParameter("threadname", defaultName);
        name = name + "-" + url.getAddress();
        url = url.addParameter("threadname", name);
        return url;
    }

    public static void cancelScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        ScheduledFuture<?> future = scheduledFuture;
        if (future != null && !future.isCancelled()) {
            future.cancel(true);
        }
    }
}

